# asdf plugins repository

The purpose of the [asdf](https://github.com/asdf-vm/asdf) plugins repository is to enable shorthand installation of plugins with:

```shell
asdf plugin add <name>
```

It is important to know that you can install plugins without them being in this repo with:

```shell
asdf plugin add <name> <git_url>
```

## Existing Plugins

Plugins listed here should be _stable_ and actively _maintained_. If you have issues with a specific plugin please raise them on the plugin repository first. If a deprecated plugin is listed here, please let us know and create a PR to add the most used alternative.

## Creating a new Plugin

- Read the [creating plugins guide](https://github.com/asdf-vm/asdf/blob/master/docs/plugins/create.md)
- Consider using our [Template](https://github.com/asdf-vm/asdf-plugin-template) which has the core functionality to tools published to GitHub releases and CI for GitHub/GitLab/CircleCI out of the box.

### `asdf-community`

If you're creating a new plugin consider creating it as part of the [`asdf-community`](https://github.com/asdf-community/.github) project. This is a separate community project with consolidated maintenance.

## Contributing a new Plugin

- Add the plugin to this `README.md`.
- Create a file with the shortname you wish to be used by asdf in `plugins/<name>`. Then contents should be `repository = <your_repo>`.
- Create a PR following the instructions in the PR template.

## Security

The `asdf` core provides a [security policy](https://github.com/asdf-vm/asdf/security/policy) which covers the core `asdf` tool. Plugins are the responsibility of their creators and not covered by the `asdf` policy. It is the responsibility of the user to evaluate each plugin they use for security concerns, even those in the `asdf-community` repositories. You can pin a plugin to a commit of the source repo with `asdf plugin update <name> <git-ref>`, however running `asdf plugin update <name>` or `asdf plugin update --all` will change the `sha` you have previously set.

## Plugin List

| Language                      | Repository                                                                                                      | CI Status                                                                                                                                                                                                                         |
| :---------------------------- | :-------------------------------------------------------------------------------------------------------------- | :-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| .Net                          | [hensou/asdf-dotnet](https://github.com/hensou/asdf-dotnet)                                                     | [![Build](https://github.com/hensou/asdf-dotnet/actions/workflows/build.yml/badge.svg)](https://github.com/hensou/asdf-dotnet/actions/workflows/build.yml)                                                                        |
| .Net Core                     | [emersonsoares/asdf-dotnet-core](https://github.com/emersonsoares/asdf-dotnet-core)                             | [![Build Status](https://travis-ci.org/emersonsoares/asdf-dotnet-core.svg?branch=master)](https://travis-ci.org/emersonsoares/asdf-dotnet-core)                                                                                   |
| 1password-cli                 | [NeoHsu/asdf-1password-cli](https://github.com/NeoHsu/asdf-1password-cli)                                       | [![Build](https://github.com/NeoHsu/asdf-1password-cli/workflows/Build/badge.svg)](https://github.com/neohsu/asdf-1password-cli/actions?query=workflow%3ABuild)                                                                   |
| act                           | [grimoh/asdf-act](https://github.com/grimoh/asdf-act)                                                           | [![GitHub Actions Status](https://github.com/grimoh/asdf-act/workflows/Main%20workflow/badge.svg?branch=master)](https://github.com/grimoh/asdf-act/actions)                                                                      |
| action-validator              | [mpalmer/action-validator](https://github.com/mpalmer/action-validator)                                         | [![Test](https://github.com/mpalmer/action-validator/workflows/Test/badge.svg?branch=main&event=push)](https://github.com/mpalmer/action-validator/actions)                                                                       |
| actionlint                    | [crazy-matt/asdf-actionlint](https://github.com/crazy-matt/asdf-actionlint)                                     | [![Build](https://github.com/crazy-matt/asdf-actionlint/actions/workflows/build.yml/badge.svg)](https://github.com/crazy-matt/asdf-actionlint/actions/workflows/build.yml)                                                        |
| adr-tools                     | [td7x/asdf/adr-tools](https://gitlab.com/td7x/asdf/adr-tools)                                                   | [![pipeline status](https://gitlab.com/td7x/asdf/adr-tools/badges/master/pipeline.svg)](https://gitlab.com/td7x/asdf/adr-tools/commits/master)                                                                                    |
| ag (the_silver_searcher)      | [koketani/asdf-ag](https://github.com/koketani/asdf-ag)                                                         | [![GitHub Actions Status](https://github.com/koketani/asdf-ag/workflows/Build/badge.svg)](https://github.com/koketani/asdf-ag/actions)                                                                                            |
| age                           | [threkk/asdf-age](https://github.com/threkk/asdf-age)                                                           | [![GitHub Actions Status](https://github.com/threkk/asdf-age/workflows/Build/badge.svg?branch=master)](https://github.com/threkk/asdf-litestream/actions)                                                                         |
| agebox                        | [slok/asdf-agebox](https://github.com/slok/asdf-agebox)                                                         | [![Build Status](https://github.com/slok/asdf-agebox/actions/workflows/ci.yml/badge.svg)](https://github.com/slok/asdf-agebox/actions)                                                                                            |
| aks-engine                    | [robsonpeixoto/aks-engine](https://github.com/robsonpeixoto/asdf-aks-engine)                                    | [![Build Status](https://travis-ci.org/robsonpeixoto/asdf-aks-engine.svg?branch=master)](https://travis-ci.org/robsonpeixoto/asdf-aks-engine)                                                                                     |
| alias                         | [andrewthauer/asdf-alias](https://github.com/andrewthauer/asdf-alias)                                           | [![Main workflow](https://github.com/andrewthauer/asdf-alias/workflows/Build/badge.svg?branch=master)](https://github.com/andrewthauer/asdf-alias/actions)                                                                        |
| allure                        | [comdotlinux/asdf-allure](https://github.com/comdotlinux/asdf-allure)                                           | [![Build](https://github.com/comdotlinux/asdf-allure2/actions/workflows/build.yml/badge.svg?branch=master)](https://github.com/comdotlinux/asdf-allure2/actions/workflows/build.yml)                                              |
| alp                           | [asdf-community/asdf-alp](https://github.com/asdf-community/asdf-alp)                                           | [![Main workflow](https://github.com/asdf-community/asdf-alp/workflows/Main%20workflow/badge.svg?branch=master)](https://github.com/asdf-community/asdf-alp/actions)                                                              |
| amass                         | [dhoeric/asdf-amass](https://github.com/dhoeric/asdf-amass)                                                     | [![Build Status](https://github.com/dhoeric/asdf-amass/workflows/Build/badge.svg?branch=main)](https://github.com/dhoeric/asdf-amass/actions)                                                                                     |
| Amazon ECR Credential Helper  | [dex4er/asdf-amazon-ecr-credential-helper](https://github.com/dex4er/asdf-amazon-ecr-credential-helper)         | [![CI](https://github.com/dex4er/asdf-amazon-ecr-credential-helper/actions/workflows/ci.yml/badge.svg)](https://github.com/dex4er/asdf-amazon-ecr-credential-helper/actions/workflows/ci.yml)                                     |
| Ansible (ansible-base)        | [amrox/asdf-pyapp](https://github.com/amrox/asdf-pyapp)                                                         | [![Build Status](https://github.com/amrox/asdf-pyapp/workflows/Build/badge.svg)](https://github.com/amrox/asdf-pyapp/actions)                                                                                                     |
| ant                           | [jackboespflug/asdf-ant](https://github.com/jackboespflug/asdf-ant)                                             | [![Build Status](https://github.com/jackboespflug/asdf-ant/workflows/Build/badge.svg?branch=main)](https://github.com/jackboespflug/asdf-ant/actions)                                                                             |
| Apache Jmeter                 | [comdotlinux/asdf-jmeter](https://github.com/comdotlinux/asdf-jmeter)                                           | [![Build Status](https://github.com/comdotlinux/asdf-jmeter/workflows/Build/badge.svg)](https://github.com/comdotlinux/asdf-jmeter/actions)                                                                                       |
| Apollo Router                 | [safx/asdf-apollo-router](https://github.com/safx/asdf-apollo-router)                                           | [![Build Status](https://github.com/safx/asdf-apollo-router/actions/workflows/build.yml/badge.svg)](https://github.com/safx/asdf-apollo-router/actions)                                                                           |
| arc                           | [arc](https://github.com/ORCID/asdf-arc)                                                                        | [![Build](https://github.com/ORCID/asdf-arc/actions/workflows/build.yml/badge.svg)](https://github.com/ORCID/asdf-arc/actions/workflows/build.yml)                                                                                |
| argo                          | [sudermanjr/argo](https://github.com/sudermanjr/asdf-argo)                                                      | [![Build Status](https://github.com/sudermanjr/asdf-argo/workflows/master/badge.svg?branch=master)](https://github.com/sudermanjr/asdf-argo/actions)                                                                              |
| argo-rollouts                 | [abatilo/asdf-argo-rollouts](https://github.com/abatilo/asdf-argo-rollouts)                                     | [![build](https://github.com/abatilo/asdf-argo-rollouts/workflows/build/badge.svg)](https://github.com/abatilo/asdf-argo-rollouts/actions?query=workflow%3A%22build%22)                                                           |
| argocd                        | [beardix/argocd](https://github.com/beardix/asdf-argocd)                                                        | [![Build Status](https://github.com/beardix/asdf-argocd/workflows/ci/badge.svg?branch=master)](https://github.com/beardix/asdf-argocd/actions)                                                                                    |
| aria2                         | [asdf-community/asdf-aria2](https://github.com/asdf-community/asdf-aria2)                                       | [![Build Status](https://github.com/asdf-community/asdf-aria2/workflows/Main%20workflow/badge.svg?branch=master)](https://github.com/asdf-community/asdf-aria2/actions)                                                           |
| asciidoctorj                  | [gliwka/asdf-asciidoctorj](https://github.com/gliwka/asdf-asciidoctorj)                                         | [![Build Status](https://github.com/gliwka/asdf-asciidoctorj/workflows/CI/badge.svg?branch=master)](https://github.com/gliwka/asdf-asciidoctorj/actions)                                                                          |
| assh                          | [zekker6/asdf-assh](https://github.com/zekker6/asdf-assh.git)                                                   | [![Test](https://github.com/zekker6/asdf-assh/actions/workflows/test.yml/badge.svg)](https://github.com/zekker6/asdf-assh/actions/workflows/test.yml)                                                                             |
| aws-amplify-cli               | [LozanoMatheus/asdf-aws-amplify-cli](https://github.com/LozanoMatheus/asdf-aws-amplify-cli)                     | [![Build](https://github.com/LozanoMatheus/asdf-aws-amplify-cli/workflows/Build/badge.svg)](https://github.com/LozanoMatheus/asdf-aws-amplify-cli/actions/workflows/build.yml)                                                    |
| aws-copilot                   | [NeoHsu/asdf-copilot](https://github.com/NeoHsu/asdf-copilot)                                                   | [![Build](https://github.com/NeoHsu/asdf-copilot/workflows/Build/badge.svg)](https://github.com/neohsu/asdf-copilot/actions?query=workflow%3ABuild)                                                                               |
| AWS IAM authenticator         | [zekker6/asdf-aws-iam-authenticator](https://github.com/zekker6/asdf-aws-iam-authenticator)                     | [![Test](https://github.com/zekker6/asdf-aws-iam-authenticator/actions/workflows/test.yml/badge.svg)](https://github.com/zekker6/asdf-aws-iam-authenticator/actions/workflows/test.yml)                                           |
| aws-nuke                      | [bersalazar/asdf-aws-nuke](https://github.com/bersalazar/asdf-aws-nuke)                                         | [![Build Status](https://github.com/bersalazar/asdf-aws-nuke/workflows/Build/badge.svg?branch=master)](https://github.com/bersalazar/asdf-aws-nuke/actions)                                                                       |
| aws-sam-cli                   | [amrox/asdf-pyapp](https://github.com/amrox/asdf-pyapp)                                                         | [![Build Status](https://github.com/amrox/asdf-pyapp/workflows/Build/badge.svg)](https://github.com/amrox/asdf-pyapp/actions)                                                                                                     |
| awscli                        | [MetricMike/asdf-awscli](https://github.com/MetricMike/asdf-awscli)                                             | [![Build Status](https://github.com/MetricMike/asdf-awscli/workflows/Build/badge.svg?branch=main)](https://github.com/MetricMike/asdf-awscli/actions)                                                                             |
| awsebcli                      | [amrox/asdf-pyapp](https://github.com/amrox/asdf-pyapp)                                                         | [![Build Status](https://github.com/amrox/asdf-pyapp/workflows/Build/badge.svg)](https://github.com/amrox/asdf-pyapp/actions)                                                                                                     |
| aws-vault                     | [karancode/asdf-aws-vault](https://github.com/karancode/asdf-aws-vault)                                         | ![GitHub Actions Status](https://github.com/karancode/asdf-aws-vault/workflows/Main%20workflow/badge.svg?branch=main)                                                                                                             |
| awsls                         | [chessmango/asdf-awsls](https://github.com/chessmango/asdf-awsls)                                               | [![GitHub Actions Status](https://github.com/chessmango/asdf-awsls/actions/workflows/build.yml/badge.svg)](https://github.com/chessmango/asdf-awsls/actions)                                                                      |
| awsrm                         | [chessmango/asdf-awsrm](https://github.com/chessmango/asdf-awsrm)                                               | [![GitHub Actions Status](https://github.com/chessmango/asdf-awsrm/actions/workflows/build.yml/badge.svg)](https://github.com/chessmango/asdf-awsrm/actions)                                                                      |
| awsweeper                     | [chessmango/asdf-awsweeper](https://github.com/chessmango/asdf-awsweeper)                                       | [![GitHub Actions Status](https://github.com/chessmango/asdf-awsweeper/actions/workflows/build.yml/badge.svg)](https://github.com/chessmango/asdf-awsweeper/actions)                                                              |
| azure-cli (az)                | [itspngu/asdf-azure-cli](https://github.com/itspngu/asdf-azure-cli)                                             | [![CI](https://github.com/itspngu/asdf-azure-cli/workflows/CI/badge.svg)](https://github.com/itspngu/asdf-azure-cli/actions)                                                                                                      |
| Azure Functions Core Tools    | [daveneeley/asdf-azure-functions-core-tools](https://github.com/daveneeley/asdf-azure-functions-core-tools)     | [![Build Status](https://github.com/daveneeley/asdf-azure-functions-core-tools/actions/workflows/build.yml/badge.svg)](https://github.com/daveneeley/asdf-azure-functions-core-tools/actions/workflows/build.yml)                 |
| babashka                      | [fredZen/asdf-babashka](https://github.com/fredZen/asdf-babashka)                                               | [![Build Status](https://github.com/fredZen/asdf-babashka/workflows/Build/badge.svg)](https://github.com/fredZen/asdf-babashka/actions)                                                                                           |
| balena-cli                    | [boatkit-io/asdf-balena-cli](https://github.com/boatkit-io/asdf-balena-cli)                                     | [![Build Status](https://github.com/boatkit-io/asdf-balena-cli/workflows/Main%20Workflow/badge.svg)](https://github.com/boatkit-io/asdf-balena-cli/blob/main/.github/workflows/workflow.yml)                                      |
| bashbot                       | [mathew-fleisch/asdf-bashbot](https://github.com/mathew-fleisch/asdf-bashbot)                                   | [![Build Status](https://github.com/mathew-fleisch/asdf-bashbot/workflows/Build/badge.svg?branch=main)](https://github.com/mathew-fleisch/asdf-bashbot/actions)                                                                   |
| bat                           | [wt0f/bat](https://gitlab.com/wt0f/asdf-bat)                                                                    | [![pipeline status](https://gitlab.com/wt0f/asdf-bat/badges/master/pipeline.svg)](https://gitlab.com/wt0f/asdf-bat/-/commits/master)                                                                                              |
| Batect                        | [johnlayton/asdf-batect](https://github.com/johnlayton/asdf-batect)                                             | [![Build Status](https://github.com/johnlayton/asdf-batect/actions/workflows/workflow.yml/badge.svg?branch=main)](https://github.com/johnlayton/asdf-batect/actions/workflows/workflow.yml)                                       |
| Bats (Bash unittest)          | [timgluz/asdf-bats](https://github.com/timgluz/asdf-bats)                                                       | [![Build Status](https://github.com/timgluz/asdf-bats/actions/workflows/asdf_test.yml/badge.svg?branch=main)](https://github.com/timgluz/asdf-bats/actions/workflows/asdf_test.yml)                                               |
| Bazel                         | [rajatvig/asdf-bazel](https://github.com/rajatvig/asdf-bazel)                                                   | [![Build Status](https://travis-ci.org/rajatvig/asdf-bazel.svg?branch=master)](https://travis-ci.org/rajatvig/asdf-bazel)                                                                                                         |
| benthos                       | [benthosdev/benthos-asdf](https://github.com/benthosdev/benthos-asdf)                                           | [![Build Status](https://github.com/benthosdev/benthos-asdf/actions/workflows/build.yml/badge.svg)](https://github.com/benthosdev/benthos-asdf/actions/workflows/build.yml)                                                       |
| binnacle                      | [Traackr/asdf-binnacle](https://github.com/Traackr/asdf-binnacle)                                               | [![Build Status](https://travis-ci.org/Traackr/asdf-binnacle.svg?branch=master)](https://travis-ci.org/Traackr/asdf-binnacle)                                                                                                     |
| Bitwarden                     | [vixus0/asdf-bitwarden](https://github.com/vixus0/asdf-bitwarden)                                               | [![Build Status](https://travis-ci.com/vixus0/asdf-bitwarden.svg?branch=master)](https://travis-ci.com/vixus0/asdf-bitwarden)                                                                                                     |
| Bombardier                    | [NeoHsu/asdf-bombardier](https://github.com/NeoHsu/asdf-bombardier)                                             | [![Build](https://github.com/NeoHsu/asdf-bombardier/workflows/Build/badge.svg)](https://github.com/neohsu/asdf-bombardier/actions?query=workflow%3ABuild)                                                                         |
| borg                          | [lwiechec/asdf-borg](https://github.com/lwiechec/asdf-borg)                                                     | [![Build](https://github.com/lwiechec/asdf-borg/workflows/Build/badge.svg)](https://github.com/lwiechec/asdf-borg/actions/workflows/build.yml)                                                                                    |
| bosh                          | [laidbackware/asdf-pivotal](https://github.com/laidbackware/asdf-pivotal)                                       | [![Build Status](https://github.com/laidbackware/asdf-pivotal/actions/workflows/test-bosh.yml/badge.svg?branch=main)](https://github.com/laidbackware/asdf-pivotal/actions/workflows/test-bosh.yml)                               |
| bottom (btm)                  | [carbonteq/asdf-btm](https://github.com/carbonteq/asdf-btm)                                                     | [![Build Status](https://github.com/carbonteq/asdf-btm/actions/workflows/build.yml/badge.svg)](https://github.com/carbonteq/asdf-btm/actions/workflows/build.yml)                                                                 |
| Boundary                      | [asdf-community/asdf-hashicorp](https://github.com/asdf-community/asdf-hashicorp)                               | [![Build](https://github.com/asdf-community/asdf-hashicorp/actions/workflows/workflow.yml/badge.svg)](https://github.com/asdf-community/asdf-hashicorp/actions/workflows/workflow.yml)                                            |
| bpkg                          | [bpkg/asdf-bpkg](https://github.com/bpkg/asdf-bpkg)                                                             | [![GitHub Actions Status](https://github.com/bpkg/asdf-bpkg/actions/workflows/build.yml/badge.svg?)](https://github.com/bpkg/asdf-bpkg/actions)                                                                                   |
| Brig                          | [Ibotta/asdf-brig](https://github.com/Ibotta/asdf-brig)                                                         | [![Build Status](https://github.com/ibotta/asdf-brig/workflows/Main%20workflow/badge.svg?branch=master)](https://github.com/ibotta/asdf-brig/actions)                                                                             |
| BTrace                        | [joschi/asdf-btrace](https://github.com/joschi/asdf-btrace)                                                     | [![Main workflow](https://github.com/joschi/asdf-btrace/actions/workflows/workflow.yml/badge.svg?branch=master)](https://github.com/joschi/asdf-btrace/actions/workflows/workflow.yml)                                            |
| Buf                           | [truepay/asdf-buf](https://github.com/truepay/asdf-buf)                                                         | [![Build Status](https://github.com/truepay/asdf-buf/workflows/CI/badge.svg?branch=master)](https://github.com/truepay/asdf-buf/actions)                                                                                          |
| Buildpack                     | [johnlayton/asdf-buildpack](https://github.com/johnlayton/asdf-buildpack)                                       | [![GitHub Actions Status](https://github.com/johnlayton/asdf-buildpack/workflows/main/badge.svg?branch=master)](https://github.com/johnlayton/asdf-buildpack/actions)                                                             |
| Bun                           | [cometkim/asdf-bun](https://github.com/cometkim/asdf-bun)                                                       | [![CI](https://github.com/cometkim/asdf-bun/actions/workflows/ci.yml/badge.svg)](https://github.com/cometkim/asdf-bun/actions/workflows/ci.yml)                                                                                   |
| Bundler                       | [jonathanmorley/asdf-bundler](https://github.com/jonathanmorley/asdf-bundler)                                   | [![Build Status](https://github.com/jonathanmorley/asdf-bundler/workflows/ASDF%20CI/badge.svg?branch=master)](https://github.com/jonathanmorley/asdf-bundler/actions)                                                             |
| Caddy                         | [salasrod/asdf-caddy](https://github.com/salasrod/asdf-caddy)                                                   | [![Build Status](https://github.com/salasrod/asdf-caddy/workflows/CI/badge.svg?branch=master)](https://github.com/salasrod/asdf-caddy/actions)                                                                                    |
| Camunda Modeler               | [barmac/asdf-camunda-modeler](https://github.com/barmac/asdf-camunda-modeler)                                   | [![Build Status](https://github.com/barmac/asdf-camunda-modeler/actions/workflows/build.yml/badge.svg?branch=main)](https://github.com/barmac/asdf-camunda-modeler/actions)                                                       |
| cargo-make                    | [kachick/asdf-cargo-make](https://github.com/kachick/asdf-cargo-make)                                           | [![Build Status](https://github.com/kachick/asdf-cargo-make/actions/workflows/build.yml/badge.svg?branch=main)](https://github.com/kachick/asdf-cargo-make/actions)                                                               |
| carthage                      | [younke/asdf-carthage](https://github.com/younke/asdf-carthage)                                                 | [![Build Status](https://github.com/younke/asdf-carthage/workflows/Build/badge.svg?branch=master)](https://github.com/younke/asdf-carthage/actions)                                                                               |
| ccache                        | [asdf-community/asdf-ccache](https://github.com/asdf-community/asdf-ccache)                                     | [![Build Status](https://github.com/asdf-community/asdf-ccache/workflows/Main%20workflow/badge.svg?branch=master)](https://github.com/asdf-community/asdf-ccache/actions)                                                         |
| certstrap                     | [carnei-ro/asdf-certstrap](https://github.com/carnei-ro/asdf-certstrap)                                         | [![Build Status](https://github.com/carnei-ro/asdf-certstrap/actions/workflows/build.yml/badge.svg?branch=main)](https://github.com/carnei-ro/asdf-certstrap/actions)                                                             |
| cidr-merger                   | [cidr-merger](https://github.com/ORCID/asdf-cidr-merger)                                                        | [![Build](https://github.com/ORCID/asdf-cidr-merger/actions/workflows/build.yml/badge.svg)](https://github.com/ORCID/asdf-cidr-merger/actions/workflows/build.yml)                                                                |
| cf                            | [mattysweeps/asdf-cf](https://github.com/mattysweeps/asdf-cf)                                                   | [![Build Status](https://travis-ci.org/mattysweeps/asdf-cf.svg?branch=master)](https://travis-ci.org/mattysweeps/asdf-cf)                                                                                                         |
| cfssl                         | [mathew-fleisch/asdf-cfssl](https://github.com/mathew-fleisch/asdf-cfssl)                                       | [![Build Status](https://github.com/mathew-fleisch/asdf-cfssl/workflows/Build/badge.svg?branch=main)](https://github.com/mathew-fleisch/asdf-cfssl/actions)                                                                       |
| chamber                       | [mintel/asdf-chamber](https://github.com/mintel/asdf-chamber)                                                   | [![Build Status](https://github.com/mintel/asdf-chamber/workflows/Build/badge.svg?branch=master)](https://github.com/mintel/asdf-chamber/actions)                                                                                 |
| cheat                         | [jmoratilla/asdf-cheat-plugin](https://github.com/jmoratilla/asdf-cheat-plugin/actions)                         | [![Build Status](https://github.com/jmoratilla/asdf-cheat-plugin/workflows/CI/badge.svg?branch=master)](https://github.com/jmoratilla/asdf-cheat-plugin/actions)                                                                  |
| checkov                       | [bosmak/asdf-checkov](https://github.com/bosmak/asdf-checkov)                                                   | [![Build Status](https://github.com/bosmak/asdf-checkov/workflows/Build/badge.svg)](https://github.com/bosmak/asdf-checkov/actions)                                                                                               |
| chezmoi                       | [joke/asdf-chezmoi](https://github.com/joke/asdf-chezmoi)                                                       | [![Build Status](https://github.com/joke/asdf-chezmoi/workflows/Build/badge.svg)](https://github.com/joke/asdf-chezmoi/actions)                                                                                                   |
| chezscheme                    | [asdf-community/asdf-chezscheme](https://github.com/asdf-community/asdf-chezscheme)                             | [![Build Status](https://github.com/asdf-community/asdf-chezscheme/workflows/Build/badge.svg?branch=master)](https://github.com/asdf-community/asdf-chezscheme/actions)                                                           |
| CHICKEN                       | [evhan/asdf-chicken](https://github.com/evhan/asdf-chicken)                                                     | [![Build Status](https://travis-ci.org/evhan/asdf-chicken.svg?branch=master)](https://travis-ci.org/evhan/asdf-chicken)                                                                                                           |
| choose                        | [carbonteq/asdf-choose](https://github.com/carbonteq/asdf-choose)                                               | [![Build Status](https://github.com/carbonteq/asdf-choose/actions/workflows/build.yml/badge.svg)](https://github.com/carbonteq/asdf-choose/actions/workflows/build.yml)                                                           |
| Chromedriver                  | [schinckel/asdf-chromedriver](https://github.com/schinckel/asdf-chromedriver)                                   | [![Build status](https://github.com/schinckel/asdf-chromedriver/actions/workflows/build.yml/badge.svg?branch=main)](https://github.com/schinckel/asdf-chromedriver/actions)                                                       |
| cilium-cli                    | [carnei-ro/asdf-cilium-cli](https://github.com/carnei-ro/asdf-cilium-cli)                                       | [![Build Status](https://github.com/carnei-ro/asdf-cilium-cli/actions/workflows/build.yml/badge.svg?branch=main)](https://github.com/carnei-ro/asdf-cilium-cli/actions)                                                           |
| cilium-hubble                 | [NitriKx/asdf-cilium-hubble](https://github.com/NitriKx/asdf-cilium-hubble)                                     | [![Build Status](https://github.com/NitriKx/asdf-cilium-hubble/actions/workflows/build.yml/badge.svg?branch=main)](https://github.com/NitriKx/asdf-cilium-hubble/actions)                                                         |
| Clojure                       | [asdf-community/asdf-clojure](https://github.com/asdf-community/asdf-clojure)                                   | [![Build Status](https://github.com/asdf-community/asdf-clojure/actions/workflows/workflow.yml/badge.svg)](https://github.com/asdf-community/asdf-clojure/actions)                                                                |
| Cloudflared                   | [threkk/asdf-cloudflared](https://github.com/threkk/asdf-cloudflared)                                           | [![GitHub Actions Status](https://github.com/threkk/asdf-cloudflared/workflows/Build/badge.svg?branch=main)](https://github.com/threkk/asdf-cloudflared/actions)                                                                  |
| cloudsql-proxy                | [itspngu/asdf-cloudsql-proxy](https://github.com/itspngu/asdf-cloudsql-proxy)                                   | [![CI](https://github.com/itspngu/asdf-cloudsql-proxy/workflows/CI/badge.svg)](https://github.com/itspngu/asdf-cloudsql-proxy/actions/workflows/test.yml)                                                                         |
| Clusterawsadm                 | [kahun/asdf-clusterawsadm](https://github.com/kahun/asdf-clusterawsadm)                                         | [![Build Status](https://github.com/kahun/asdf-clusterawsadm/workflows/CI/badge.svg)](https://github.com/kahun/asdf-clusterawsadm/actions/workflows/workflow.yml)                                                                 |
| Clusterctl                    | [pfnet-research/asdf-clusterctl](https://github.com/pfnet-research/asdf-clusterctl)                             | [![Build Status](https://github.com/pfnet-research/asdf-clusterctl/workflows/CI/badge.svg)](https://github.com/pfnet-research/asdf-clusterctl/actions?query=workflow%3ACI)                                                        |
| cmctl                         | [asdf-community/asdf-cmctl](https://github.com/asdf-community/asdf-cmctl)                                       | [![Build Status](https://github.com/asdf-community/asdf-cmctl/workflows/CI/badge.svg)](https://github.com/asdf-community/asdf-cmctl/actions/workflows/ci.yaml)                                                                    |
| CMake                         | [asdf-community/asdf-cmake](https://github.com/asdf-community/asdf-cmake)                                       | [![Build](https://github.com/asdf-community/asdf-cmake/actions/workflows/build.yml/badge.svg)](https://github.com/asdf-community/asdf-cmake/actions/workflows/build.yml)                                                          |
| CockroachDB                   | [salasrod/asdf-cockroach](https://github.com/salasrod/asdf-cockroach)                                           | [![Build Status](https://github.com/salasrod/asdf-cockroach/workflows/CI/badge.svg?branch=master)](https://github.com/salasrod/asdf-cockroach/actions)                                                                            |
| Codefresh                     | [gurukulkarni/asdf-codefresh](https://github.com/gurukulkarni/asdf-codefresh)                                   | [![Build Status](https://github.com/gurukulkarni/asdf-codefresh/workflows/Build/badge.svg)](https://github.com/gurukulkarni/asdf-codefresh/actions)                                                                               |
| CodeQL                        | [bored-engineer/asdf-codeql](https://github.com/bored-engineer/asdf-codeql)                                     | [![Build Status](https://github.com/bored-engineer/asdf-codeql/workflows/Build/badge.svg)](https://github.com/bored-engineer/asdf-codeql/actions)                                                                                 |
| Conan                         | [amrox/asdf-pyapp](https://github.com/amrox/asdf-pyapp)                                                         | [![Build Status](https://github.com/amrox/asdf-pyapp/workflows/Build/badge.svg)](https://github.com/amrox/asdf-pyapp/actions)                                                                                                     |
| Concourse                     | [mattysweeps/asdf-concourse](https://github.com/mattysweeps/asdf-concourse)                                     | [![Build Status](https://travis-ci.org/mattysweeps/asdf-concourse.svg?branch=master)](https://travis-ci.org/mattysweeps/asdf-concourse)                                                                                           |
| Conduit                       | [gmcabrita/asdf-conduit](https://github.com/gmcabrita/asdf-conduit)                                             | [![Build Status](https://travis-ci.org/gmcabrita/asdf-conduit.svg?branch=master)](https://travis-ci.org/gmcabrita/asdf-conduit)                                                                                                   |
| Conform                       | [skyzyx/asdf-conform](https://github.com/skyzyx/asdf-conform)                                                   | [![Build Status](https://travis-ci.org/skyzyx/asdf-conform.svg?branch=master)](https://travis-ci.org/skyzyx/asdf-conform)                                                                                                         |
| conftest                      | [looztra/asdf-conftest](https://github.com/looztra/asdf-conftest)                                               | [![Build Status](https://travis-ci.org/looztra/asdf-conftest.svg?branch=master)](https://travis-ci.org/looztra/asdf-conftest)                                                                                                     |
| Consul                        | [asdf-community/asdf-hashicorp](https://github.com/asdf-community/asdf-hashicorp)                               | [![Build](https://github.com/asdf-community/asdf-hashicorp/actions/workflows/workflow.yml/badge.svg)](https://github.com/asdf-community/asdf-hashicorp/actions/workflows/workflow.yml)                                            |
| container-diff                | [cgroschupp/asdf-container-diff](https://github.com/cgroschupp/asdf-container-diff)                             | [![Main workflow](https://github.com/cgroschupp/asdf-container-diff/workflows/CI/badge.svg?branch=master)](https://github.com/cgroschupp/asdf-container-diff/actions)                                                             |
| container-structure-test      | [jonathanmorley/asdf-container-structure-test](https://github.com/jonathanmorley/asdf-container-structure-test) | [![ASDF CI](https://github.com/jonathanmorley/asdf-container-structure-test/actions/workflows/asdf_ci.yml/badge.svg?branch=main)](https://github.com/jonathanmorley/asdf-container-structure-test/actions/workflows/asdf_ci.yml)  |
| cookiecutter                  | [shawon-crosen/asdf-cookiecutter](https://github.com/shawon-crosen/asdf-cookiecutter)                           | [![Build Status](https://github.com/laidbackware/asdf-pivotal/actions/workflows/test-credhub.yml/badge.svg?branch=main)](https://github.com/shawon-crosen/asdf-cookiecutter)                                                      |
| Copper                        | [vladlosev/asdf-copper](https://github.com/vladlosev/asdf-copper)                                               | [![Build Status](https://github.com/vladlosev/asdf-copper/workflows/Build/badge.svg)](https://github.com/vladlosev/asdf-copper/actions?query=workflow%3ABuild)                                                                    |
| Coq                           | [gingerhot/asdf-coq](https://github.com/gingerhot/asdf-coq)                                                     | [![Build Status](https://travis-ci.org/gingerhot/asdf-coq.svg?branch=master)](https://travis-ci.org/gingerhot/asdf-coq)                                                                                                           |
| cosign                        | [wt0f/asdf-cosign](https://gitlab.com/wt0f/asdf-cosign)                                                         | [![Build Status](https://gitlab.com/wt0f/asdf-cosign/badges/main/pipeline.svg)](https://gitlab.com/wt0f/asdf-cosign/-/pipelines)                                                                                                  |
| coursier                      | [jiahuili430/asdf-coursier](https://github.com/jiahuili430/asdf-coursier)                                       | [![Build Status](https://github.com/jiahuili430/asdf-coursier/actions/workflows/build.yml/badge.svg)](https://github.com/jiahuili430/asdf-coursier/actions/workflows/build.yml)                                                   |
| crane                         | [dmpe/asdf-crane](https://github.com/dmpe/asdf-crane)                                                           | [![Build Status](https://github.com/dmpe/asdf-crane/actions/workflows/build.yml/badge.svg)](https://github.com/dmpe/asdf-crane/actions/workflows/build.yml)                                                                       |
| crc                           | [sqtran/asdf-crc](https://github.com/sqtran/asdf-crc)                                                           | [![Build Status](https://github.com/sqtran/asdf-crc/workflows/CI/badge.svg?branch=master)](https://github.com/sqtran/asdf-crc)                                                                                                    |
| credhub                       | [laidbackware/asdf-pivotal](https://github.com/laidbackware/asdf-pivotal)                                       | [![Build Status](https://github.com/laidbackware/asdf-pivotal/actions/workflows/test-credhub.yml/badge.svg?branch=main)](https://github.com/laidbackware/asdf-pivotal/actions/workflows/test-credhub.yml)                         |
| crossplane-cli                | [joke/asdf-crossplane-cli](https://github.com/joke/asdf-crossplane-cli)                                         | [![Build Status](https://github.com/joke/asdf-crossplane-cli/workflows/Build/badge.svg)](https://github.com/joke/asdf-crossplane-cli/actions)                                                                                     |
| ctlptl                        | [ezcater/asdf-ctlptl](https://github.com/ezcater/asdf-ctlptl)                                                   | [![Build Status](https://github.com/ezcater/asdf-ctlptl/workflows/Main%20Workflow/badge.svg?branch=master)](https://github.com/ezcater/asdf-ctlptl/actions)                                                                       |
| Crystal                       | [asdf-community/asdf-crystal](https://github.com/asdf-community/asdf-crystal)                                   | [![Main workflow](https://github.com/asdf-community/asdf-crystal/workflows/Main%20workflow/badge.svg?branch=master)](https://github.com/asdf-community/asdf-crystal/actions)                                                      |
| ctop                          | [NeoHsu/asdf-ctop](https://github.com/NeoHsu/asdf-ctop)                                                         | [![Build](https://github.com/NeoHsu/asdf-ctop/workflows/Build/badge.svg)](https://github.com/neohsu/asdf-ctop/actions?query=workflow%3ABuild)                                                                                     |
| CUE                           | [asdf-community/asdf-cue](https://github.com/asdf-community/asdf-cue)                                           | [![Build Status](https://github.com/asdf-community/asdf-cue/workflows/Main%20workflow/badge.svg?branch=master)](https://github.com/asdf-community/asdf-cue/actions)                                                               |
| D (DMD)                       | [sylph01/asdf-dmd](https://github.com/sylph01/asdf-dmd)                                                         | [![Build Status](https://travis-ci.org/sylph01/asdf-dmd.svg?branch=master)](https://travis-ci.org/sylph01/asdf-dmd)                                                                                                               |
| dagger                        | [virtualstaticvoid/asdf-dagger](https://github.com/virtualstaticvoid/asdf-dagger)                               | [![Build Status](https://github.com/virtualstaticvoid/asdf-dagger/actions/workflows/workflow.yml/badge.svg?branch=main)](https://github.com/virtualstaticvoid/asdf-dagger/actions/workflows/workflow.yml)                         |
| Dart                          | [PatOConnor43/asdf-dart](https://github.com/PatOConnor43/asdf-dart)                                             | [![Build Status](https://travis-ci.org/PatOConnor43/asdf-dart.svg?branch=master)](https://travis-ci.org/PatOConnor43/asdf-dart)                                                                                                   |
| Dasel                         | [asdf-community/asdf-dasel](https://github.com/asdf-community/asdf-dasel)                                       | [![Build Status](https://github.com/asdf-community/asdf-dasel/workflows/ci/badge.svg)](ttps://github.com/asdf-community/asdf-dasel/actions)                                                                                       |
| datree                        | [lukeab/asdf-datree](https://github.com/lukeab/asdf-datree)                                                     | [![Build Status](https://github.com/lukeab/asdf-datree/actions/workflows/build.yml/badge.svg)](https://github.com/lukeab/asdf-datree/actions)                                                                                     |
| Dbmate                        | [juusujanar/asdf-dbmate](https://github.com/juusujanar/asdf-dbmate)                                             | [![Test](https://github.com/juusujanar/asdf-dbmate/actions/workflows/test.yaml/badge.svg)](https://github.com/juusujanar/asdf-dbmate/actions)                                                                                     |
| Deck                          | [nutellinoit/asdf-deck](https://github.com/nutellinoit/asdf-deck)                                               | [![Build Status](https://github.com/nutellinoit/asdf-deck/workflows/Build/badge.svg)](https://github.com/nutellinoit/asdf-deck/actions)                                                                                           |
| Delta                         | [andweeb/asdf-delta](https://github.com/andweeb/asdf-delta)                                                     | [![Build Status](https://github.com/andweeb/asdf-delta/workflows/Build/badge.svg)](https://github.com/andweeb/asdf-delta/actions)                                                                                                 |
| Deno                          | [asdf-community/asdf-deno](https://github.com/asdf-community/asdf-deno)                                         | [![Main workflow](https://github.com/asdf-community/asdf-deno/workflows/Main%20workflow/badge.svg?branch=master)](https://github.com/asdf-community/asdf-deno/actions)                                                            |
| Dep                           | [paxosglobal/asdf-dep](https://github.com/paxosglobal/asdf-dep)                                                 | [![Build Status](https://travis-ci.com/paxosglobal/asdf-dep.svg?branch=master)](https://travis-ci.com/paxosglobal/asdf-dep)                                                                                                       |
| depot                         | [depot/asdf-depot](https://github.com/depot/asdf-depot)                                                         | [![Build](https://github.com/depot/asdf-depot/actions/workflows/build.yml/badge.svg)](https://github.com/depot/asdf-depot/actions/workflows/build.yml)                                                                            |
| Desk                          | [endorama/asdf-desk](https://github.com/endorama/asdf-desk)                                                     | [![Build Status](https://travis-ci.org/endorama/asdf-desk.svg?branch=master)](https://travis-ci.org/endorama/asdf-desk)                                                                                                           |
| DevSpace                      | [NeoHsu/asdf-devspace](https://github.com/NeoHsu/asdf-devspace)                                                 | [![Build](https://github.com/NeoHsu/asdf-devspace/workflows/Build/badge.svg)](https://github.com/neohsu/asdf-devspace/actions?query=workflow%3ABuild)                                                                             |
| DevStream                     | [zhenyuanlau/asdf-dtm](https://github.com/zhenyuanlau/asdf-dtm)                                                 | [![Build](https://github.com/zhenyuanlau/asdf-dtm/workflows/Build/badge.svg)](https://github.com/zhenyuanlau/asdf-dtm/actions?query=workflow%3ABuild)                                                                             |
| dhall                         | [aaaaninja/asdf-dhall](https://github.com/aaaaninja/asdf-dhall)                                                 | [![Build Status](https://travis-ci.com/aaaaninja/asdf-dhall.svg?branch=master)](https://travis-ci.com/aaaaninja/asdf-dhall)                                                                                                       |
| difftastic                    | [volf52/asdf-difftastic](https://github.com/volf52/asdf-difftastic)                                             | [![Build](https://github.com/volf52/asdf-difftastic/actions/workflows/build.yml/badge.svg)](https://github.com/volf52/asdf-difftastic)                                                                                            |
| digdag                        | [jtakakura/asdf-digdag](https://github.com/jtakakura/asdf-digdag)                                               | [![Main workflow](https://github.com/jtakakura/asdf-digdag/workflows/Main%20workflow/badge.svg?branch=master)](https://github.com/jtakakura/asdf-digdag/actions)                                                                  |
| direnv                        | [asdf-community/asdf-direnv](https://github.com/asdf-community/asdf-direnv)                                     | [![Main workflow](https://github.com/asdf-community/asdf-direnv/workflows/Main%20workflow/badge.svg?branch=master)](https://github.com/asdf-community/asdf-direnv/actions)                                                        |
| dive                          | [looztra/asdf-dive](https://github.com/looztra/asdf-dive)                                                       | [![Build Status](https://travis-ci.org/looztra/asdf-dive.svg?branch=master)](https://travis-ci.org/looztra/asdf-dive)                                                                                                             |
| djinni                        | [cross-language-cpp/asdf-djinni](https://github.com/cross-language-cpp/asdf-djinni.git)                         | [![Build](https://github.com/cross-language-cpp/asdf-djinni/workflows/Build/badge.svg?event=push&branch=main)](https://github.com/cross-language-cpp/asdf-djinni/actions)                                                         |
| docker-slim                   | [everpeace/asdf-docker-slim](https://github.com/everpeace/asdf-docker-slim.git)                                 | [![Build Status](https://travis-ci.org/everpeace/asdf-docker-slim.svg?branch=master)](https://travis-ci.org/everpeace/asdf-docker-slim)                                                                                           |
| docker-compose-v1             | [kompiro/asdf-docker-compose-v1](https://github.com/kompiro/asdf-docker-compose-v1.git)                         | [![Build Status](https://github.com/kompiro/asdf-docker-compose-v1/actions/workflows/build.yml/badge.svg)](https://github.com/kompiro/asdf-docker-compose-v1/actions/workflows/build.yml)                                         |
| dockle                        | [mathew-fleisch/asdf-semver](https://github.com/mathew-fleisch/asdf-dockle)                                     | [![Build Status](https://github.com/mathew-fleisch/asdf-dockle/workflows/Build/badge.svg?branch=main)](https://github.com/mathew-fleisch/asdf-dockle/actions)                                                                     |
| doctl                         | [maristgeek/asdf-doctl](https://github.com/maristgeek/asdf-doctl)                                               | [![Build Status](https://travis-ci.org/maristgeek/asdf-doctl.svg?branch=master)](https://travis-ci.org/maristgeek/asdf-doctl)                                                                                                     |
| docToolchain                  | [joschi/asdf-doctoolchain](https://github.com/joschi/asdf-doctoolchain)                                         | [![Main workflow](https://github.com/joschi/asdf-doctoolchain/workflows/Main%20workflow/badge.svg?branch=master)](https://github.com/joschi/asdf-doctoolchain/actions)                                                            |
| docuum                        | [bradym/asdf-docuum](https://github.com/bradym/asdf-docuum)                                                     | [![GitHub Workflow Status](https://github.com/bradym/asdf-docuum/workflows/Main%20workflow/badge.svg?branch=master)](https://github.com/bradym/asdf-docuum/actions)                                                               |
| DOME                          | [jtakakura/asdf-dome](https://github.com/jtakakura/asdf-dome)                                                   | [![Build Status](https://github.com/jtakakura/asdf-dome/workflows/Build/badge.svg)](https://github.com/jtakakura/asdf-dome/actions?query=workflow%3ABuild)                                                                        |
| dotenv-linter                 | [wesleimp/asdf-dotenv-linter](https://github.com/wesleimp/asdf-dotenv-linter)                                   | [![Build Status](https://github.com/wesleimp/asdf-dotenv-linter/workflows/ci/badge.svg)](https://github.com/wesleimp/asdf-dotenv-linter/actions)                                                                                  |
| Dotty                         | [asdf-community/asdf-dotty](https://github.com/asdf-community/asdf-dotty)                                       | [![Build Status](https://github.com/asdf-community/asdf-dotty/workflows/Main%20workflow/badge.svg)](https://github.com/asdf-community/asdf-dotty/actions)                                                                         |
| dprint                        | [asdf-community/asdf-dprint](https://github.com/asdf-community/asdf-dprint)                                     | [![Build Status](https://github.com/asdf-community/asdf-dprint/workflows/Main%20workflow/badge.svg)](https://github.com/asdf-community/asdf-dprint/actions)                                                                       |
| Draft                         | [kristoflemmens/asdf-draft](https://github.com/kristoflemmens/asdf-draft)                                       | [![Build Status](https://travis-ci.org/kristoflemmens/asdf-draft.svg?branch=master)](https://travis-ci.org/kristoflemmens/asdf-draft)                                                                                             |
| Driftctl                      | [nlamirault/asdf-driftctl](https://github.com/nlamirault/asdf-driftctl)                                         | [![GitHub Actions Status](https://github.com/nlamirault/asdf-driftctl/workflows/main/badge.svg?branch=master)](https://github.com/nlamirault/asdf-driftctl/actions)                                                               |
| drone                         | [virtualstaticvoid/asdf-drone](https://github.com/virtualstaticvoid/asdf-drone)                                 | [![Build Status](https://github.com/virtualstaticvoid/asdf-drone/actions/workflows/workflow.yml/badge.svg?branch=main)](https://github.com/virtualstaticvoid/asdf-drone/actions/workflows/workflow.yml)                           |
| duf                           | [NeoHsu/asdf-duf](https://github.com/NeoHsu/asdf-duf)                                                           | [![Build](https://github.com/NeoHsu/asdf-duf/workflows/Build/badge.svg)](https://github.com/neohsu/asdf-duf/actions?query=workflow%3ABuild)                                                                                       |
| dust                          | [looztra/asdf-dust](https://github.com/looztra/asdf-dust)                                                       | [![GitHub Actions Status](https://github.com/looztra/asdf-dust/workflows/Main%20workflow/badge.svg?branch=master)](https://github.com/looztra/asdf-dust/actions)                                                                  |
| dyff                          | [wt0f/asdf-dyff](https://gitlab.com/wt0f/asdf-dyff)                                                             | [![pipeline status](https://gitlab.com/wt0f/asdf-dyff/badges/master/pipeline.svg)](https://gitlab.com/wt0f/asdf-dyff/-/commits/master)                                                                                            |
| editorconfig-checker          | [gabitchov/asdf-editorconfig-checker](https://github.com/gabitchov/asdf-editorconfig-checker)                   | [![Build Status](https://travis-ci.org/Gabitchov/asdf-editorconfig-checker.svg?branch=master)](https://travis-ci.org/Gabitchov/asdf-editorconfig-checker)                                                                         |
| ejson                         | [cipherstash/asdf-ejson](https://github.com/cipherstash/asdf-ejson)                                             | [![Build](https://github.com/cipherstash/asdf-ejson/workflows/Build/badge.svg?branch=main&event=push)](https://github.com/cipherstash/asdf-ejson/actions)                                                                         |
| eksctl                        | [elementalvoid/asdf-eksctl](https://github.com/elementalvoid/asdf-eksctl)                                       | [![GitHub Actions Status](https://github.com/elementalvoid/asdf-eksctl/workflows/Main%20workflow/badge.svg?branch=master)](https://github.com/elementalvoid/asdf-eksctl/actions)                                                  |
| Elasticsearch                 | [asdf-community/asdf-elasticsearch](https://github.com/asdf-community/asdf-elasticsearch)                       | [![Build Status](https://github.com/asdf-community/asdf-elasticsearch/workflows/Main%20workflow/badge.svg?branch=master)](https://github.com/asdf-community/asdf-elasticsearch/actions)                                           |
| Elixir                        | [asdf-vm/asdf-elixir](https://github.com/asdf-vm/asdf-elixir)                                                   | [![Build Status](https://travis-ci.org/asdf-vm/asdf-elixir.svg?branch=master)](https://travis-ci.org/asdf-vm/asdf-elixir)                                                                                                         |
| Elm                           | [asdf-community/asdf-elm](https://github.com/asdf-community/asdf-elm)                                           | [![Build Status](https://github.com/asdf-community/asdf-elm/workflows/Main%20workflow/badge.svg?branch=master)](https://github.com/asdf-community/asdf-elm/actions)                                                               |
| embulk                        | [yuokada/asdf-embulk](https://github.com/yuokada/asdf-embulk)                                                   | [![Build Status](https://github.com/yuokada/asdf-embulk/workflows/Test%20asdf%20plugin/badge.svg?branch=master)](https://github.com/yuokada/asdf-embulk/actions)                                                                  |
| Emscripten SDK                | [RobLoach/asdf-emsdk](https://github.com/RobLoach/asdf-emsdk)                                                   | [![Build Status](https://github.com/RobLoach/asdf-emsdk/workflows/Main%20workflow/badge.svg?branch=master)](https://github.com/RobLoach/asdf-emsdk/actions)                                                                       |
| EnvCLI                        | [zekker6/asdf-envcli](https://github.com/zekker6/asdf-envcli)                                                   | [![Build Status](https://github.com/RobLoach/asdf-emsdk/workflows/Main%20workflow/badge.svg?branch=master)](https://github.com/zekker6/asdf-envcli/actions)                                                                       |
| Ephemeral Postgres            | [smashedtoatoms/asdf-ephemeral-postgres](https://github.com/smashedtoatoms/asdf-ephemeral-postgres)             | [![Build Status](https://github.com/smashedtoatoms/asdf-ephemeral-postgres/workflows/Build/badge.svg?branch=master)](https://github.com/smashedtoatoms/asdf-ephemeral-postgres/actions)                                           |
| Erlang                        | [asdf-vm/asdf-erlang](https://github.com/asdf-vm/asdf-erlang)                                                   | [![Build Status](https://travis-ci.org/asdf-vm/asdf-erlang.svg?branch=master)](https://travis-ci.org/asdf-vm/asdf-erlang)                                                                                                         |
| esy                           | [asdf-community/asdf-esy](https://github.com/asdf-community/asdf-esy)                                           | [![Build Status](https://github.com/asdf-community/asdf-esy/workflows/Main%20workflow/badge.svg?branch=master)](https://github.com/asdf-community/asdf-esy/actions)                                                               |
| etcd                          | [particledecay/asdf-etcd](https://github.com/particledecay/asdf-etcd)                                           | [![Build Status](https://travis-ci.org/particledecay/asdf-etcd.svg?branch=master)](https://travis-ci.org/particledecay/asdf-etcd)                                                                                                 |
| exa                           | [nyrst/asdf-exa](https://github.com/nyrst/asdf-exa)                                                             | [![pipeline status](https://github.com/nyrst/asdf-exa/workflows/Build/badge.svg)](https://github.com/nyrst/asdf-exa/actions)                                                                                                      |
| fd                            | [wt0f/asdf-fd](https://gitlab.com/wt0f/asdf-fd)                                                                 | [![pipeline status](https://gitlab.com/wt0f/asdf-fd/badges/master/pipeline.svg)](https://gitlab.com/wt0f/asdf-fd/-/commits/master)                                                                                                |
| FFmpeg                        | [acj/asdf-ffmpeg](https://github.com/acj/asdf-ffmpeg)                                                           | [![Build Status](https://github.com/acj/asdf-ffmpeg/actions/workflows/build.yml/badge.svg)](https://github.com/acj/asdf-ffmpeg/actions/workflows/build.yml)                                                                       |
| figma-export                  | [younke/asdf-figma-export](https://github.com/younke/asdf-figma-export)                                         | [![Build Status](https://github.com/younke/asdf-figma-export/workflows/Build/badge.svg?branch=main)](https://github.com/younke/asdf-figma-export/actions)                                                                         |
| fillin                        | [ouest/asdf-fillin](https://github.com/ouest/asdf-fillin)                                                       | [![Build Status](https://github.com/ouest/asdf-fillin/workflows/Build/badge.svg?branch=main)](https://github.com/ouest/asdf-fillin/actions)                                                                                       |
| firebase                      | [jthegedus/asdf-firebase](https://github.com/jthegedus/asdf-firebase)                                           | [![Build](https://github.com/jthegedus/asdf-firebase/workflows/Build/badge.svg?branch=master)](https://github.com/jthegedus/asdf-firebase/actions)                                                                                |
| fission                       | [virtualstaticvoid/asdf-fission](https://github.com/virtualstaticvoid/asdf-fission)                             | [![Build Status](https://github.com/virtualstaticvoid/asdf-fission/actions/workflows/workflow.yml/badge.svg?branch=main)](https://github.com/virtualstaticvoid/asdf-fission/actions/workflows/workflow.yml)                       |
| flarectl                      | [flarectl](https://github.com/ORCID/asdf-flarectl)                                                              | [![Build](https://github.com/ORCID/asdf-flarectl/actions/workflows/build.yml/badge.svg)](https://github.com/ORCID/asdf-flarectl/actions/workflows/build.yml)                                                                      |
| Flutter                       | [oae/asdf-flutter](https://github.com/oae/asdf-flutter)                                                         | [![Build Status](https://travis-ci.com/oae/asdf-flutter.svg?branch=master)](https://travis-ci.com/oae/asdf-flutter)                                                                                                               |
| Flux2                         | [tablexi/asdf-flux2](https://github.com/tablexi/asdf-flux2)                                                     | [![Main workflow](https://github.com/tablexi/asdf-flux2/workflows/Main%20workflow/badge.svg?branch=master)](https://github.com/tablexi/asdf-flux2/actions)                                                                        |
| Fluxctl                       | [stefansedich/asdf-fluxctl](https://github.com/stefansedich/asdf-fluxctl)                                       | [![Build Status](https://travis-ci.com/stefansedich/asdf-fluxctl.svg?branch=master)](https://travis-ci.com/stefansedich/asdf-fluxctl)                                                                                             |
| fly                           | [laidbackware/asdf-pivotal](https://github.com/laidbackware/asdf-pivotal)                                       | [![Build Status](https://github.com/laidbackware/asdf-pivotal/actions/workflows/test-fly.yml/badge.svg?branch=main)](https://github.com/laidbackware/asdf-pivotal/actions/workflows/test-fly.yml)                                 |
| flyctl                        | [chessmango/asdf-flyctl](https://github.com/chessmango/asdf-flyctl)                                             | [![GitHub Actions Status](https://github.com/chessmango/asdf-flyctl/actions/workflows/build.yml/badge.svg)](https://github.com/chessmango/asdf-flyctl/actions)                                                                    |
| func-e                        | [carnei-ro/asdf-func-e](https://github.com/carnei-ro/asdf-func-e)                                               | [![Build Status](https://github.com/carnei-ro/asdf-func-e/actions/workflows/build.yml/badge.svg?branch=main)](https://github.com/carnei-ro/asdf-func-e/actions)                                                                   |
| Furyctl                       | [sighupio/asdf-furyctl](https://github.com/sighupio/asdf-furyctl)                                               | [![Build Status](https://github.com/sighupio/asdf-furyctl/actions/workflows/build.yml/badge.svg?branch=main)](https://github.com/sighupio/asdf-furyctl/actions)                                                                   |
| fx                            | [wt0f/asdf-fx](https://gitlab.com/wt0f/asdf-fx)                                                                 | [![Build Status](https://gitlab.com/wt0f/asdf-fx/badges/main/pipeline.svg)](https://gitlab.com/wt0f/asdf-fx/-/pipelines)                                                                                                          |
| fzf                           | [kompiro/asdf-fzf](https://github.com/kompiro/asdf-fzf)                                                         | [![Build Status](https://github.com/kompiro/asdf-fzf/workflows/plugin%20test/badge.svg)](https://github.com/kompiro/asdf-fzf/actions?query=workflow%3A%22plugin+test%22)                                                          |
| Gauche                        | [sakuro/asdf-gauche](https://github.com/sakuro/asdf-gauche)                                                     | [![Build Status](https://travis-ci.org/sakuro/asdf-gauche.svg?branch=master)](https://travis-ci.org/sakuro/asdf-gauche)                                                                                                           |
| gam                           | [offbyone/asdf-gam](https://github.com/offbyone/asdf-gam)                                                       | [![Build Status](https://github.com/offbyone/asdf-gam/workflows/ASDF%20CI/badge.svg)](https://github.com/offbyone/asdf-gam/actions)                                                                                               |
| gator                         | [MxNxPx/asdf-gator](https://github.com/MxNxPx/asdf-gator)                                                       | [![Build Status](https://github.com/MxNxPx/asdf-gator/actions/workflows/build.yml/badge.svg)](https://github.com/MxNxPx/asdf-gator/actions)                                                                                       |
| gcc-arm-none-eabi             | [dlech/asdf-gcc-arm-none-eabi](https://github.com/dlech/asdf-gcc-arm-none-eabi)                                 | [![Build](https://github.com/dlech/asdf-gcc-arm-none-eabi/actions/workflows/build.yml/badge.svg)](https://github.com/dlech/asdf-gcc-arm-none-eabi/actions/workflows/build.yml)                                                    |
| gcloud                        | [jthegedus/asdf-gcloud](https://github.com/jthegedus/asdf-gcloud)                                               | [![Build](https://github.com/jthegedus/asdf-gcloud/workflows/Build/badge.svg?branch=master)](https://github.com/jthegedus/asdf-gcloud/actions)                                                                                    |
| getenvoy                      | [asdf-community/asdf-getenvoy](https://github.com/asdf-community/asdf-getenvoy)                                 | [![Build Status](https://github.com/asdf-community/asdf-getenvoy/workflows/CI/badge.svg)](https://github.com/asdf-community/asdf-getenvoy/actions)                                                                                |
| ghidra                        | [Honeypot95/asdf-ghidra](https://github.com/Honeypot95/asdf-ghidra)                                             | [![Build Status](https://travis-ci.com/Honeypot95/asdf-ghidra.svg?branch=master)](https://travis-ci.com/Honeypot95/asdf-ghidra)                                                                                                   |
| ghorg                         | [gbloquel/asdf-ghorg](https://github.com/gbloquel/asdf-ghorg)                                                   | [![Build Status](https://github.com/gbloquel/asdf-ghorg/actions/workflows/build.yml/badge.svg?branch=main)](https://github.com/gbloquel/asdf-ghorg/actions)                                                                       |
| ghq                           | [kajisha/asdf-ghq](https://github.com/kajisha/asdf-ghq)                                                         | [![Build Status](https://github.com/kajisha/asdf-ghq/workflows/Main%20workflow/badge.svg?branch=master)](https://github.com/kajisha/asdf-ghq/actions)                                                                             |
| ginkgo                        | [jimmidyson/asdf-ginkgo](https://github.com/jimmidyson/asdf-ginkgo)                                             | [![Build Status](https://github.com/jimmidyson/asdf-ginkgo/workflows/ci/badge.svg?branch=main)](https://github.com/jimmidyson/asdf-ginkgo/actions)                                                                                |
| git                           | [jcaigitlab/asdf-git](https://gitlab.com/jcaigitlab/asdf-git)                                                   | [![GitLab CI Status](https://gitlab.com/jcaigitlab/asdf-git/badges/main/pipeline.svg)](https://gitlab.com/jcaigitlab/asdf-git/-/pipelines)                                                                                        |
| git-chglog                    | [GoodwayGroup/asdf-git-chglog](https://github.com/GoodwayGroup/asdf-git-chglog)                                 | [![GitHub Actions Status](https://github.com/GoodwayGroup/asdf-git-chglog/workflows/test/badge.svg?branch=main)](https://github.com/GoodwayGroup/asdf-git-chglog/actions)                                                         |
| gitconfig                     | [0ghny/asdf-gitconfig](https://github.com/0ghny/asdf-gitconfig)                                                 | [![Github Actions Status](https://github.com/0ghny/asdf-gitconfig/actions/workflows/build.yml/badge.svg)](https://github.com/0ghny/asdf-gitconfig/actions/workflows/build.yml)                                                    |
| GitHub CLI                    | [bartlomiejdanek/asdf-github-cli](https://github.com/bartlomiejdanek/asdf-github-cli)                           | [![Build Status](https://github.com/bartlomiejdanek/asdf-github-cli/workflows/CI/badge.svg?branch=master)](https://github.com/bartlomiejdanek/asdf-github-cli/actions)                                                            |
| GitHub Markdown ToC           | [skyzyx/asdf-github-markdown-toc](https://github.com/skyzyx/asdf-github-markdown-toc)                           | [![Build Status](https://travis-ci.org/skyzyx/asdf-github-markdown-toc.svg?branch=master)](https://travis-ci.org/skyzyx/asdf-github-markdown-toc)                                                                                 |
| Gitleaks                      | [jmcvetta/asdf-gitleaks](https://github.com/jmcvetta/asdf-gitleaks)                                             | [![Build](https://github.com/jmcvetta/asdf-gitleaks/actions/workflows/build.yml/badge.svg)](https://github.com/jmcvetta/asdf-gitleaks/actions/workflows/build.yml)                                                                |
| Gitsign                       | [spencergilbert/asdf-gitsign](https://github.com/spencergilbert/asdf-gitsign)                                   | [![Build](https://github.com/spencergilbert/asdf-gitsign/actions/workflows/build.yml/badge.svg)](https://github.com/spencergilbert/asdf-gitsign/actions/workflows/build.yml)                                                      |
| gitui                         | [looztra/asdf-gitui](https://github.com/looztra/asdf-gitui)                                                     | [![GitHub Actions Status](https://github.com/looztra/asdf-gitui/workflows/Main%20workflow/badge.svg?branch=master)](https://github.com/looztra/asdf-gitui/actions)                                                                |
| GLab                          | [particledecay/asdf-glab](https://github.com/particledecay/asdf-glab)                                           | [![Build](https://github.com/particledecay/asdf-glab/actions/workflows/build.yml/badge.svg)](https://github.com/particledecay/asdf-glab/actions/workflows/build.yml)                                                              |
| Gleam                         | [vic/asdf-gleam](https://github.com/vic/asdf-gleam)                                                             | [![Build Status](https://travis-ci.org/vic/asdf-gleam.svg?branch=master)](https://travis-ci.org/vic/asdf-gleam)                                                                                                                   |
| Glen                          | [bradym/glen](https://github.com/bradym/asdf-glen)                                                              | [![Main workflow](https://github.com/bradym/asdf-glen/actions/workflows/workflow.yaml/badge.svg)](https://github.com/bradym/asdf-glen/actions/workflows/workflow.yaml)                                                            |
| glooctl                       | [halilkaya/asdf-glooctl](https://github.com/halilkaya/asdf-glooctl)                                             | [![ci](https://github.com/halilkaya/asdf-glooctl/actions/workflows/ci.yml/badge.svg)](https://github.com/halilkaya/asdf-glooctl/actions/workflows/ci.yml)                                                                         |
| glow                          | [chessmango/asdf-glow](https://github.com/chessmango/asdf-glow)                                                 | [![GitHub Actions Status](https://github.com/chessmango/asdf-glow/actions/workflows/build.yml/badge.svg)](https://github.com/chessmango/asdf-glow/actions)                                                                        |
| GNU Guile                     | [indiebrain/asdf-guile](https://github.com/indiebrain/asdf-guile)                                               | [![Build Status](https://travis-ci.org/indiebrain/asdf-guile.svg?branch=master)](https://travis-ci.org/indiebrain/asdf-guile)                                                                                                     |
| GNU nano                      | [mfakane/asdf-nano](https://github.com/mfakane/asdf-nano)                                                       | [![GitHub Actions Status](https://github.com/mfakane/asdf-nano/actions/workflows/build.yml/badge.svg?branch=master)](https://github.com/mfakane/asdf-nano/actions)                                                                |
| Go                            | [kennyp/asdf-golang](https://github.com/kennyp/asdf-golang)                                                     | [![Build Status](https://travis-ci.org/kennyp/asdf-golang.svg?branch=master)](https://travis-ci.org/kennyp/asdf-golang)                                                                                                           |
| go-sdk                        | [yacchi/asdf-go-sdk](https://github.com/yacchi/asdf-go-sdk)                                                     | [![Build](https://github.com/yacchi/asdf-go-sdk/actions/workflows/build.yml/badge.svg)](https://github.com/yacchi/asdf-go-sdk/actions/workflows/build.yml)                                                                        |
| go-containerregistry          | [dex4er/asdf-go-containerregistry](https://github.com/dex4er/asdf-go-containerregistry)                         | [![CI](https://github.com/dex4er/asdf-go-containerregistry/actions/workflows/ci.yml/badge.svg)](https://github.com/dex4er/asdf-go-containerregistry/actions/workflows/ci.yml)                                                     |
| go-getter                     | [ryodocx/asdf-go-getter](https://github.com/ryodocx/asdf-go-getter)                                             | [![GitHub Actions Status](https://github.com/ryodocx/asdf-go-getter/workflows/Build/badge.svg)](https://github.com/ryodocx/asdf-go-getter/actions)                                                                                |
| go-jsonnet                    | [craigfurman/asdf-go-jsonnet](https://gitlab.com/craigfurman/asdf-go-jsonnet)                                   | [![Build Status](https://gitlab.com/craigfurman/asdf-go-jsonnet/badges/master/pipeline.svg)](https://gitlab.com/craigfurman/asdf-go-jsonnet/-/pipelines)                                                                          |
| go-jira                       | [dguihal/asdf-go-jira](https://github.com/dguihal/asdf-go-jira)                                                 | [![GitHub Actions Status](https://github.com/dguihal/asdf-go-jira/workflows/Main%20workflow/badge.svg?branch=master)](https://github.com/dguihal/asdf-go-jira/actions)                                                            |
| go-junit-report               | [jwillker/asdf-go-junit-report](https://github.com/jwillker/asdf-go-junit-report)                               | [![GitHub Actions Status](https://github.com/jwillker/asdf-go-junit-report/actions/workflows/build.yml/badge.svg)](https://github.com/jwillker/asdf-go-junit-report/actions/workflows/build.yml)                                  |
| go-swagger                    | [jfreeland/asdf-go-swagger](https://github.com/jfreeland/asdf-go-swagger)                                       | [![Build Status](https://github.com/jfreeland/asdf-go-swagger/workflows/build/badge.svg)](https://github.com/jfreeland/asdf-go-swagger/actions?query=workflow%3Abuild)                                                            |
| GoHugo                        | [nklmilojevic/asdf-hugo](https://github.com/nklmilojevic/asdf-hugo)                                             | [![Build Status](https://github.com/nklmilojevic/asdf-hugo/actions/workflows/build.yml/badge.svg)](https://github.com/nklmilojevic/asdf-hugo/actions)                                                                             |
| gojq                          | [jimmidyson/asdf-gojq](https://github.com/jimmidyson/asdf-gojq)                                                 | [![Build Status](https://github.com/jimmidyson/asdf-gojq/workflows/ci/badge.svg?branch=main)](https://github.com/jimmidyson/asdf-gojq/actions)                                                                                    |
| golangci-lint                 | [hypnoglow/asdf-golangci-lint](https://github.com/hypnoglow/asdf-golangci-lint)                                 | [![Build Status](https://github.com/hypnoglow/asdf-golangci-lint/workflows/master/badge.svg?branch=master)](https://github.com/hypnoglow/asdf-golangci-lint/actions)                                                              |
| Go Migrate                    | [joschi/asdf-gomigrate](https://github.com/joschi/asdf-gomigrate)                                               | [![Main workflow](https://github.com/joschi/asdf-gomigrate/workflows/Main%20workflow/badge.svg?branch=master)](https://github.com/joschi/asdf-gomigrate/actions)                                                                  |
| gomplate                      | [sneakybeaky/asdf-gomplate](https://github.com/sneakybeaky/asdf-gomplate)                                       | [![Build Status](https://github.com/sneakybeaky/asdf-gomplate/workflows/CI/badge.svg)](https://github.com/sneakybeaky/asdf-gomplate/actions)                                                                                      |
| Gopass                        | [trallnag/asdf-gopass](https://github.com/trallnag/asdf-gopass)                                                 | [![primary](https://github.com/trallnag/asdf-gopass/actions/workflows/primary.yaml/badge.svg)](https://github.com/trallnag/asdf-gopass/actions/workflows/primary.yaml)                                                            |
| GoReleaser                    | [kforsthoevel/asdf-goreleaser](https://github.com/kforsthoevel/asdf-goreleaser)                                 | [![Main workflow](https://github.com/kforsthoevel/asdf-goreleaser/workflows/Main%20workflow/badge.svg?branch=master)](https://github.com/kforsthoevel/asdf-goreleaser/actions)                                                    |
| Goss                          | [raimon49/asdf-goss](https://github.com/raimon49/asdf-goss)                                                     | [![plugin test](https://github.com/raimon49/asdf-goss/workflows/plugin%20test/badge.svg)](https://github.com/raimon49/asdf-goss/actions/workflows/asdf.yml)                                                                       |
| GraalVM                       | [asdf-community/asdf-graalvm](https://github.com/asdf-community/asdf-graalvm)                                   | [![Build Status](https://github.com/asdf-community/asdf-graalvm/workflows/plugin-test/badge.svg?branch=master)](https://github.com/asdf-community/asdf-graalvm/actions)                                                           |
| Gradle                        | [rfrancis/asdf-gradle](https://github.com/rfrancis/asdf-gradle)                                                 | [![Build Status](https://travis-ci.org/rfrancis/asdf-gradle.svg?branch=master)](https://travis-ci.org/rfrancis/asdf-gradle)                                                                                                       |
| Gradle Profiler               | [joschi/asdf-gradle-profiler](https://github.com/joschi/asdf-gradle-profiler)                                   | [![CI](https://github.com/joschi/asdf-gradle-profiler/actions/workflows/workflow.yml/badge.svg?branch=master)](https://github.com/joschi/asdf-gradle-profiler/actions/workflows/workflow.yml)                                     |
| Grails                        | [weibemoura/asdf-grails](https://github.com/weibemoura/asdf-grails)                                             | [![Build Status](https://travis-ci.org/weibemoura/asdf-grails.svg?branch=master)](https://travis-ci.org/weibemoura/asdf-grails)                                                                                                   |
| Grain                         | [cometkim/asdf-grain](https://github.com/cometkim/asdf-grain)                                                   | [![CI](https://github.com/cometkim/asdf-grain/actions/workflows/ci.yml/badge.svg)](https://github.com/cometkim/asdf-grain/actions/workflows/ci.yml)                                                                               |
| Granted                       | [dex4er/asdf-granted](https://github.com/dex4er/asdf-granted)                                                   | [![CI](https://github.com/dex4er/asdf-granted/actions/workflows/ci.yml/badge.svg)](https://github.com/dex4er/asdf-granted/actions/workflows/ci.yml)                                                                               |
| grex                          | [ouest/asdf-grex](https://github.com/ouest/asdf-grex)                                                           | [![Build Status](https://github.com/ouest/asdf-grex/workflows/Build/badge.svg?branch=main)](https://github.com/ouest/asdf-grex/actions)                                                                                           |
| Groovy                        | [weibemoura/asdf-groovy](https://github.com/weibemoura/asdf-groovy)                                             | [![Build Status](https://travis-ci.org/weibemoura/asdf-groovy.svg?branch=master)](https://travis-ci.org/weibemoura/asdf-groovy)                                                                                                   |
| grpcurl                       | [asdf-community/asdf-grpcurl](https://github.com/asdf-community/asdf-grpcurl)                                   | [![CI](https://github.com/asdf-community/asdf-grpcurl/workflows/CI/badge.svg)](https://github.com/asdf-community/asdf-grpcurl/actions?query=workflow%3ACI)                                                                        |
| grpc-health-probe             | [zufardhiyaulhaq/asdf-grpc-health-probe](https://github.com/zufardhiyaulhaq/asdf-grpc-health-probe)             | [![Build](https://github.com/zufardhiyaulhaq/asdf-grpc-health-probe/actions/workflows/build.yml/badge.svg)](https://github.com/zufardhiyaulhaq/asdf-grpc-health-probe/actions/workflows/build.yml)                                |
| grype                         | [poikilotherm/asdf-grype](https://github.com/poikilotherm/asdf-grype)                                           | [![Main](https://github.com/poikilotherm/asdf-grype/workflows/Main/badge.svg?branch=main)](https://github.com/poikilotherm/asdf-grype/actions?query=workflow%3AMain)                                                              |
| gum                           | [lwiechec/asdf-gum](https://github.com/lwiechec/asdf-gum)                                                       | [![Build](https://github.com/lwiechec/asdf-gum/workflows/Build/badge.svg)](https://github.com/lwiechec/asdf-gum/actions/workflows/build.yml)                                                                                      |
| gwvault                       | [GoodwayGroup/asdf-gwvault](https://github.com/GoodwayGroup/asdf-gwvault)                                       | [![GitHub Actions Status](https://github.com/GoodwayGroup/asdf-gwvault/workflows/test/badge.svg?branch=main)](https://github.com/GoodwayGroup/asdf-gwvault/actions)                                                               |
| hadolint                      | [devlincashman/asdf-hadolint](https://github.com/devlincashman/asdf-hadolint)                                   | [![Build Status](https://github.com/devlincashman/asdf-hadolint/actions/workflows/build.yml/badge.svg)](https://github.com/devlincashman/asdf-hadolint/actions/workflows/build.yml)                                               |
| Hamler                        | [scudelletti/asdf-hamler](https://github.com/scudelletti/asdf-hamler)                                           | [![Build](https://github.com/scudelletti/asdf-hamler/workflows/Build/badge.svg)](https://github.com/scudelletti/asdf-hamler/actions)                                                                                              |
| has                           | [sylvainmetayer/asdf-has](https://github.com/sylvainmetayer/asdf-has)                                           | [![Build](https://github.com/sylvainmetayer/asdf-has/workflows/Main%20workflow/badge.svg?branch=main)](https://github.com/sylvainmetayer/asdf-has/actions)                                                                        |
| Haskell                       | [asdf-community/asdf-haskell](https://github.com/asdf-community/asdf-haskell)                                   | [![Build Status](https://travis-ci.org/asdf-community/asdf-haskell.svg?branch=master)](https://travis-ci.org/asdf-community/asdf-haskell)                                                                                         |
| Hasura-cli                    | [gurukulkarni/asdf-hasura](https://github.com/gurukulkarni/asdf-hasura)                                         | [![GitHub Actions Status](https://github.com/gurukulkarni/asdf-hasura/workflows/Build/badge.svg?branch=master)](https://github.com/gurukulkarni/asdf-hasura/actions?query=workflow%3ABuild)                                       |
| Haxe                          | [asdf-community/asdf-haxe](https://github.com/asdf-community/asdf-haxe)                                         | [![Build Status](https://github.com/asdf-community/asdf-haxe/workflows/Main%20workflow/badge.svg?branch=master)](https://github.com/asdf-community/asdf-haxe/actions)                                                             |
| hcl2json                      | [dex4er/asdf-hcl2json](https://github.com/dex4er/asdf-hcl2json)                                                 | [![CI](https://github.com/dex4er/asdf-hcl2json/actions/workflows/ci.yml/badge.svg)](https://github.com/dex4er/asdf-hcl2json/actions/workflows/ci.yml)                                                                             |
| hcloud                        | [chessmango/asdf-hcloud](https://github.com/chessmango/asdf-hcloud)                                             | [![GitHub Actions Status](https://github.com/chessmango/asdf-hcloud/actions/workflows/build.yml/badge.svg)](https://github.com/chessmango/asdf-hcloud/actions)                                                                    |
| Helm                          | [Antiarchitect/asdf-helm](https://github.com/Antiarchitect/asdf-helm)                                           | [![Build Status](https://travis-ci.org/Antiarchitect/asdf-helm.svg?branch=master)](https://travis-ci.org/Antiarchitect/asdf-helm)                                                                                                 |
| Helm Chart Releaser           | [Antiarchitect/asdf-helm-cr](https://github.com/Antiarchitect/asdf-helm-cr)                                     | [![Main workflow](https://github.com/Antiarchitect/asdf-helm-cr/workflows/Main%20workflow/badge.svg?branch=master)](https://github.com/Antiarchitect/asdf-helm-cr/actions)                                                        |
| Helm Chart Tester             | [tablexi/asdf-helm-ct](https://github.com/tablexi/asdf-helm-ct)                                                 | [![Main workflow](https://github.com/tablexi/asdf-helm-ct/workflows/Main%20workflow/badge.svg?branch=master)](https://github.com/tablexi/asdf-helm-ct/actions)                                                                    |
| Helm Diff                     | [dex4er/asdf-helm-diff](https://github.com/dex4er/asdf-helm-diff)                                               | [![CI](https://github.com/dex4er/asdf-helm-diff/actions/workflows/ci.yml/badge.svg)](https://github.com/dex4er/asdf-helm-diff/actions/workflows/ci.yml)                                                                           |
| helm-docs                     | [sudermanjr/asdf-helm-docs](https://github.com/sudermanjr/asdf-helm-docs)                                       | [![Build Status](https://github.com/sudermanjr/asdf-helm-docs/workflows/master/badge.svg?branch=master)](https://github.com/sudermanjr/asdf-helm-docs/actions)                                                                    |
| Helmfile                      | [feniix/asdf-helmfile](https://github.com/feniix/asdf-helmfile)                                                 | [![Build Status](https://travis-ci.org/feniix/asdf-helmfile.svg?branch=master)](https://travis-ci.org/feniix/asdf-helmfile)                                                                                                       |
| Helmsman                      | [luisdavim/asdf-helmsman](https://github.com/luisdavim/asdf-helmsman)                                           | [![Build Status](https://app.travis-ci.com/luisdavim/asdf-helmsman.svg?branch=master)](https://app.travis-ci.com/luisdavim/asdf-helmsman)                                                                                         |
| heroku-cli                    | [treilly94/asdf-heroku-cli](https://github.com/treilly94/asdf-heroku-cli)                                       | [![Build](https://github.com/treilly94/asdf-heroku-cli/actions/workflows/build.yml/badge.svg)](https://github.com/treilly94/asdf-heroku-cli/actions/workflows/build.yml)                                                          |
| hey                           | [raimon49/asdf-hey](https://github.com/raimon49/asdf-hey)                                                       | [![plugin test](https://github.com/raimon49/asdf-goss/workflows/plugin%20test/badge.svg)](https://github.com/raimon49/asdf-goss/actions/workflows/asdf.yml)                                                                       |
| httpie-go                     | [abatilo/asdf-httpie-go](https://github.com/abatilo/asdf-httpie-go)                                             | [![build](https://github.com/abatilo/asdf-httpie-go/workflows/build/badge.svg)](https://github.com/abatilo/asdf-httpie-go/actions?query=workflow%3A%22build%22)                                                                   |
| Hub                           | [vixus0/asdf-hub](https://github.com/vixus0/asdf-hub)                                                           | [![Build Status](https://travis-ci.com/vixus0/asdf-hub.svg?branch=master)](https://travis-ci.com/vixus0/asdf-hub)                                                                                                                 |
| Hugo                          | [NeoHsu/asdf-hugo](https://github.com/NeoHsu/asdf-hugo)                                                         | [![Build](https://github.com/NeoHsu/asdf-hugo/workflows/Build/badge.svg)](https://github.com/neohsu/asdf-hugo/actions?query=workflow%3ABuild)                                                                                     |
| Hurl                          | [raimon49/asdf-hurl](https://github.com/raimon49/asdf-hurl)                                                     | [![Build](https://github.com/raimon49/asdf-hurl/actions/workflows/build.yml/badge.svg)](https://github.com/raimon49/asdf-hurl/actions/workflows/build.yml)                                                                        |
| hwatch                        | [chessmango/asdf-hwatch](https://github.com/chessmango/asdf-hwatch)                                             | [![GitHub Actions Status](https://github.com/chessmango/asdf-hwatch/actions/workflows/build.yml/badge.svg)](https://github.com/chessmango/asdf-hwatch/actions)                                                                    |
| Hygen                         | [brentjanderson/asdf-hygen](https://github.com/brentjanderson/asdf-hygen)                                       | [![CI](https://github.com/brentjanderson/asdf-hygen/actions/workflows/ci.yml/badge.svg)](https://github.com/brentjanderson/asdf-hygen/actions/workflows/ci.yml)                                                                   |
| Hyperfine                     | [volf52/asdf-hyperfine](https://github.com/volf52/asdf-hyperfine)                                               | [![Build](https://github.com/volf52/asdf-hyperfine/actions/workflows/build.yml/badge.svg)](https://github.com/volf52/asdf-hyperfine/actions/workflows/build.yml)                                                                  |
| iamlive                       | [chessmango/asdf-iamlive](https://github.com/chessmango/asdf-iamlive)                                           | [![GitHub Actions Status](https://github.com/chessmango/asdf-iamlive/actions/workflows/build.yml/badge.svg)](https://github.com/chessmango/asdf-iamlive/actions)                                                                  |
| iam-policy-json-to-terraform  | [carlduevel/asdf-iam-policy-json-to-terraform](https://github.com/carlduevel/asdf-iam-policy-json-to-terraform) | [![Build Status](https://github.com/carlduevel/asdf-iam-policy-json-to-terraform/actions/workflows/build.yml/badge.svg?branch=main)](https://github.com/carlduevel/asdf-iam-policy-json-to-terraform/actions/workflows/build.yml) |
| Idris                         | [asdf-community/asdf-idris](https://github.com/asdf-community/asdf-idris)                                       | [![Build Status](https://travis-ci.org/asdf-community/asdf-idris.svg?branch=master)](https://travis-ci.org/asdf-community/asdf-idris)                                                                                             |
| Idris2                        | [asdf-community/asdf-idris2](https://github.com/asdf-community/asdf-idris2)                                     | [![Build](https://github.com/asdf-community/asdf-idris2/workflows/Build/badge.svg)](https://github.com/asdf-community/asdf-idris2/actions?query=workflow%3ABuild)                                                                 |
| ImageMagick                   | [mangalakader/asdf-imagemagick](https://github.com/mangalakader/asdf-imagemagick)                               | [![Imagemagick Plugin Test](https://github.com/mangalakader/asdf-imagemagick/workflows/Imagemagick%20Plugin%20Test/badge.svg)](https://github.com/mangalakader/asdf-imagemagick/actions/workflows/main.yml)                       |
| imgpkg                        | [vmware-tanzu/asdf-carvel](https://github.com/vmware-tanzu/asdf-carvel)                                         | [![Build Status](https://github.com/vmware-tanzu/asdf-carvel/workflows/test-all/badge.svg)](https://github.com/vmware-tanzu/asdf-carvel/actions)                                                                                  |
| Infracost                     | [dex4er/asdf-infracost](https://github.com/dex4er/asdf-infracost)                                               | [![CI](https://github.com/dex4er/asdf-infracost/actions/workflows/ci.yml/badge.svg)](https://github.com/dex4er/asdf-infracost/actions/workflows/ci.yml)                                                                           |
| Inlets                        | [nlamirault/asdf-inlets](https://github.com/nlamirault/asdf-inlets)                                             | [![GitHub Actions Status](https://github.com/nlamirault/asdf-inlets/workflows/main/badge.svg?branch=master)](https://github.com/nlamirault/asdf-inlets/actions)                                                                   |
| Io                            | [mracos/asdf-io](https://github.com/mracos/asdf-io)                                                             | [![Build](https://travis-ci.org/mracos/asdf-io.svg?branch=master)](https://travis-ci.org/mracos/asdf-io)                                                                                                                          |
| Istioctl                      | [virtualstaticvoid/asdf-istioctl](https://github.com/virtualstaticvoid/asdf-istioctl)                           | [![Build](https://github.com/virtualstaticvoid/asdf-istioctl/workflows/Main%20Workflow/badge.svg)](https://github.com/virtualstaticvoid/asdf-istioctl/actions?query=workflow%3AMain%20Workflow)                                   |
| Janet                         | [Jakski/asdf-janet](https://github.com/Jakski/asdf-janet)                                                       | [![Build](https://github.com/Jakski/asdf-janet/actions/workflows/build.yml/badge.svg)](https://github.com/Jakski/asdf-janet/actions/workflows/build.yml)                                                                          |
| Java                          | [halcyon/asdf-java](https://github.com/halcyon/asdf-java)                                                       | [![Build Status](https://github.com/halcyon/asdf-java/workflows/asdf-java%20Tests/badge.svg?branch=master)](https://github.com/halcyon/asdf-java/actions?query=workflow%3A%22asdf-java+Tests%22+branch%3Amaster)                  |
| jb                            | [beardix/asdf-jb](https://github.com/beardix/asdf-jb)                                                           | [![GitHub Actions Status](https://github.com/beardix/asdf-jb/workflows/ci/badge.svg?branch=master)](https://github.com/beardix/asdf-jb/actions)                                                                                   |
| jbang                         | [joschi/asdf-jbang](https://github.com/joschi/asdf-jbang)                                                       | [![Main workflow](https://github.com/joschi/asdf-jbang/workflows/Main%20workflow/badge.svg?branch=main)](https://github.com/joschi/asdf-jbang/actions)                                                                            |
| jib                           | [joschi/asdf-jib](https://github.com/joschi/asdf-jib)                                                           | [![Main workflow](https://github.com/joschi/asdf-jib/workflows/Main%20workflow/badge.svg?branch=master)](https://github.com/joschi/asdf-jib/actions)                                                                              |
| jiq                           | [chessmango/asdf-jiq](https://github.com/chessmango/asdf-jiq)                                                   | [![GitHub Actions Status](https://github.com/chessmango/asdf-jiq/actions/workflows/build.yml/badge.svg)](https://github.com/chessmango/asdf-jiq/actions)                                                                          |
| jless                         | [jc00ke/asdf-jless](https://github.com/jc00ke/asdf-jless)                                                       | [![Build Status](https://github.com/jc00ke/asdf-jless/workflows/Build/badge.svg?branch=main)](https://github.com/jc00ke/asdf-jless/actions)                                                                                       |
| JMESPath                      | [skyzyx/asdf-jmespath](https://github.com/skyzyx/asdf-jmespath)                                                 | [![Build Status](https://travis-ci.org/skyzyx/asdf-jmespath.svg?branch=master)](https://travis-ci.org/skyzyx/asdf-jmespath)                                                                                                       |
| jq                            | [azmcode/asdf-jq](https://github.com/azmcode/asdf-jq)                                                           | [![GitHub Actions Status](https://github.com/azmcode/asdf-jq/workflows/ci/badge.svg?branch=master)](https://github.com/azmcode/asdf-jq/actions)                                                                                   |
| jqp                           | [wt0f/bat](https://gitlab.com/wt0f/asdf-jqp)                                                                    | [![pipeline status](https://gitlab.com/wt0f/asdf-jqp/badges/main/pipeline.svg)](https://gitlab.com/wt0f/asdf-jqp/-/commits/main)                                                                                                  |
| JReleaser                     | [joschi/asdf-jreleaser](https://github.com/joschi/asdf-jreleaser)                                               | [![GitHub Actions Status](https://github.com/joschi/asdf-jreleaser/workflows/Main%20workflow/badge.svg?branch=master)](https://github.com/joschi/asdf-jreleaser/actions)                                                          |
| json2k8s                      | [k14s/asdf-k14s](https://github.com/k14s/asdf-k14s)                                                             | [![Build Status](https://github.com/k14s/asdf-k14s/workflows/test-all/badge.svg)](https://github.com/k14s/asdf-k14s/actions)                                                                                                      |
| Jsonnet                       | [Banno/asdf-jsonnet](https://github.com/Banno/asdf-jsonnet)                                                     | [![Build Status](https://travis-ci.org/Banno/asdf-jsonnet.svg?branch=master)](https://travis-ci.org/Banno/asdf-jsonnet)                                                                                                           |
| Julia                         | [rkyleg/asdf-julia](https://github.com/rkyleg/asdf-julia)                                                       | [![Build Status](https://github.com/rkyleg/asdf-julia/workflows/CI/badge.svg)](https://github.com/rkyleg/asdf-julia/actions)                                                                                                      |
| Just                          | [olofvndrhr/asdf-just](https://github.com/olofvndrhr/asdf-just)                                                 | [![Build Status](https://github.com/olofvndrhr/asdf-just/actions/workflows/build.yml/badge.svg)](https://github.com/olofvndrhr/asdf-just/actions/workflows/build.yml)                                                             |
| jx                            | [vbehar/asdf-jx](https://github.com/vbehar/asdf-jx)                                                             | [![Build Status](https://travis-ci.org/vbehar/asdf-jx.svg?branch=master)](https://travis-ci.org/vbehar/asdf-jx)                                                                                                                   |
| k2tf                          | [carlduevel/asdf-k2tf](https://github.com/carlduevel/asdf-k2tf)                                                 | [![GitHub Actions Status](https://github.com/carlduevel/asdf-k2tf/actions/workflows/build.yml/badge.svg?branch=main)](https://github.com/carlduevel/asdf-k2tf/actions)                                                            |
| k3d                           | [spencergilbert/asdf-k3d](https://github.com/spencergilbert/asdf-k3d)                                           | [![GitHub Actions Status](https://github.com/spencergilbert/asdf-k3d/workflows/Main/badge.svg?branch=master)](https://github.com/spencergilbert/asdf-k3d/actions)                                                                 |
| k3sup                         | [cgroschupp/asdf-k3sup](https://github.com/cgroschupp/asdf-k3sup)                                               | [![GitHub Actions Status](https://github.com/cgroschupp/asdf-k3sup/workflows/Build/badge.svg?branch=master)](https://github.com/cgroschupp/asdf-k3sup/actions)                                                                    |
| k6                            | [grimoh/asdf-k6](https://github.com/grimoh/asdf-k6)                                                             | [![GitHub Actions Status](https://github.com/grimoh/asdf-k6/workflows/Main%20workflow/badge.svg?branch=master)](https://github.com/grimoh/asdf-k6/actions)                                                                        |
| k9s                           | [looztra/asdf-k9s](https://github.com/looztra/asdf-k9s)                                                         | [![Build Status](https://travis-ci.org/looztra/asdf-k9s.svg?branch=master)](https://travis-ci.org/looztra/asdf-k9s)                                                                                                               |
| kafka                         | [ueisele/asdf-kafka](https://github.com/ueisele/asdf-kafka)                                                     | [![Build Status](https://github.com/ueisele/asdf-kafka/actions/workflows/build.yml/badge.svg?branch=main)](https://github.com/ueisele/asdf-kafka)                                                                                 |
| kafkactl                      | [anweber/asdf-kafkactl](https://github.com/anweber/asdf-kafkactl)                                               | [![Build Status](https://github.com/anweber/asdf-kafkactl/actions/workflows/build.yml/badge.svg?branch=main)](https://github.com/anweber/asdf-kafkactl)                                                                           |
| kapp                          | [vmware-tanzu/asdf-carvel](https://github.com/vmware-tanzu/asdf-carvel)                                         | [![Build Status](https://github.com/vmware-tanzu/asdf-carvel/workflows/test-all/badge.svg)](https://github.com/vmware-tanzu/asdf-carvel/actions)                                                                                  |
| kbld                          | [vmware-tanzu/asdf-carvel](https://github.com/vmware-tanzu/asdf-carvel)                                         | [![Build Status](https://github.com/vmware-tanzu/asdf-carvel/workflows/test-all/badge.svg)](https://github.com/vmware-tanzu/asdf-carvel/actions)                                                                                  |
| kcat                          | [douglasdgoulart/asdf-kcat](https://github.com/douglasdgoulart/asdf-kcat)                                       | [![Build Status](https://github.com/douglasdgoulart/asdf-kcat/actions/workflows/build.yml/badge.svg?branch=main)](https://github.com/douglasdgoulart/asdf-kcat/actions)                                                           |
| kcctl                         | [joschi/asdf-kcctl](https://github.com/joschi/asdf-kcctl)                                                       | [![Main workflow](https://github.com/joschi/asdf-kcctl/actions/workflows/workflow.yml/badge.svg?branch=main)](https://github.com/joschi/asdf-kcctl/actions/workflows/workflow.yml)                                                |
| kconf                         | [particledecay/asdf-kconf](https://github.com/particledecay/asdf-kconf)                                         | [![Test Plugin](https://github.com/particledecay/asdf-kconf/workflows/Plugin%20Test/badge.svg)](https://github.com/particledecay/asdf-kconf/actions)                                                                              |
| Kind                          | [johnlayton/asdf-kind](https://github.com/johnlayton/asdf-kind)                                                 | [![GitHub Actions Status](https://github.com/johnlayton/asdf-kind/workflows/main/badge.svg?branch=master)](https://github.com/johnlayton/asdf-kind/actions)                                                                       |
| ki                            | [comdotlinux/asdf-ki](https://github.com/comdotlinux/asdf-ki)                                                   | [![Build Status](https://github.com/comdotlinux/asdf-ki/workflows/Build/badge.svg)](https://github.com/comdotlinux/asdf-ki/actions)                                                                                               |
| kn                            | [joke/asdf-kn](https://github.com/joke/asdf-kn)                                                                 | [![Build Status](https://github.com/joke/asdf-kn/workflows/main/badge.svg)](https://github.com/joke/asdf-kn/actions)                                                                                                              |
| ko                            | [zasdaym/asdf-ko](https://github.com/zasdaym/asdf-ko)                                                           | [![Build Status](https://github.com/zasdaym/asdf-ko/workflows/test/badge.svg)](https://github.com/zasdaym/asdf-ko/actions)                                                                                                        |
| Kompose                       | [technikhil314/kompose](https://github.com/technikhil314/asdf-kompose)                                          | [![GitHub Actions Status](https://github.com/technikhil314/asdf-kompose/workflows/Build/badge.svg?branch=master)](https://github.com/technikhil314/asdf-kompose/actions)                                                          |
| Kops                          | [Antiarchitect/asdf-kops](https://github.com/Antiarchitect/asdf-kops)                                           | [![Build Status](https://travis-ci.org/Antiarchitect/asdf-kops.svg?branch=master)](https://travis-ci.org/Antiarchitect/asdf-kops)                                                                                                 |
| Kotlin                        | [asdf-community/asdf-kotlin](https://github.com/asdf-community/asdf-kotlin)                                     | [![Build Status](https://travis-ci.org/asdf-community/asdf-kotlin.svg?branch=master)](https://travis-ci.org/asdf-community/asdf-kotlin)                                                                                           |
| Kpt                           | [nlamirault/asdf-kpt](https://github.com/nlamirault/asdf-kpt)                                                   | [![GitHub Actions Status](https://github.com/nlamirault/asdf-kpt/workflows/main/badge.svg?branch=master)](https://github.com/nlamirault/asdf-kpt/actions)                                                                         |
| kscript                       | [edgelevel/asdf-kscript](https://github.com/edgelevel/asdf-kscript)                                             | [![Build Status](https://travis-ci.org/edgelevel/asdf-kscript.svg?branch=master)](https://travis-ci.org/edgelevel/asdf-kscript)                                                                                                   |
| krew                          | [jimmidyson/asdf-krew](https://github.com/jimmidyson/asdf-krew)                                                 | [![Build Status](https://github.com/jimmidyson/asdf-krew/workflows/ci/badge.svg?branch=main)](https://github.com/jimmidyson/asdf-krew/actions)                                                                                    |
| Ksonnet                       | [Banno/asdf-ksonnet](https://github.com/Banno/asdf-ksonnet)                                                     | [![Build Status](https://travis-ci.org/Banno/asdf-ksonnet.svg?branch=master)](https://travis-ci.org/Banno/asdf-ksonnet)                                                                                                           |
| ktlint                        | [esensar/asdf-ktlint](https://github.com/esensar/asdf-ktlint)                                                   | [![Build Status](https://github.com/esensar/asdf-ktlint/actions/workflows/build.yml/badge.svg)](https://github.com/esensar/asdf-ktlint/actions/workflows/build.yml)                                                               |
| kube-capacity                 | [looztra/asdf-kube-capacity](https://github.com/looztra/asdf-kube-capacity)                                     | [![Build Status](https://travis-ci.org/looztra/asdf-kube-capacity.svg?branch=master)](https://travis-ci.org/looztra/asdf-kube-capacity)                                                                                           |
| kube-code-generator           | [jimmidyson/asdf-kube-code-generator](https://github.com/jimmidyson/asdf-kube-code-generator)                   | [![Build Status](https://github.com/jimmidyson/asdf-kube-code-generator/workflows/ci/badge.svg?branch=main)](https://github.com/jimmidyson/asdf-kube-code-generator/actions)                                                      |
| kube-controller-tools         | [jimmidyson/asdf-kube-controller-tools](https://github.com/jimmidyson/asdf-kube-controller-tools)               | [![Build Status](https://github.com/jimmidyson/asdf-kube-controller-tools/workflows/ci/badge.svg?branch=main)](https://github.com/jimmidyson/asdf-kube-controller-tools/actions)                                                  |
| kube-credential-cache         | [ryodocx/kube-credential-cache](https://github.com/ryodocx/kube-credential-cache)                               | [![GitHub Actions Status](https://github.com/ryodocx/kube-credential-cache/workflows/asdf-test/badge.svg)](https://github.com/ryodocx/kube-credential-cache/actions)                                                              |
| kube-linter                   | [devlincashman/asdf-kube-linter](https://github.com/devlincashman/asdf-kube-linter)                             | [![Build Status](https://github.com/devlincashman/asdf-kube-linter/actions/workflows/build.yml/badge.svg?branch=main)](https://github.com/devlincashman/asdf-kube-linter/actions/workflows/build.yml)                             |
| kube-score                    | [bageljp/asdf-kube-score](https://github.com/bageljp/asdf-kube-score)                                           | [![Build Status](https://github.com/bageljp/asdf-kube-score/actions/workflows/build.yml/badge.svg?branch=main)](https://github.com/bageljp/asdf-kube-score/actions/workflows/build.yml)                                           |
| kubebuilder                   | [virtualstaticvoid/kubebuilder](https://github.com/virtualstaticvoid/asdf-kubebuilder)                          | [![GitHub Actions Status](https://github.com/virtualstaticvoid/asdf-kubebuilder/workflows/Main%20Workflow/badge.svg?branch=master)](https://github.com/virtualstaticvoid/asdf-kubebuilder/actions)                                |
| kubecm                        | [samhvw8/asdf-kubecm](https://github.com/samhvw8/asdf-kubecm)                                                   | [![GitHub Actions Status](https://github.com/samhvw8/asdf-kubecm/actions/workflows/build.yml/badge.svg)](https://github.com/samhvw8/asdf-kubecm/actions)                                                                          |
| kubeconform                   | [lirlia/asdf-kubeconform](https://github.com/lirlia/asdf-kubeconform)                                           | [![GitHub Actions Status](https://github.com/lirlia/asdf-kubeconform/actions/workflows/build.yml/badge.svg?branch=main)](https://github.com/lirlia/asdf-kubeconform/actions/workflows/build.yml)                                  |
| Kubectl                       | [asdf-community/asdf-kubectl](https://github.com/asdf-community/asdf-kubectl)                                   | [![Build Status](https://travis-ci.org/asdf-community/asdf-kubectl.svg?branch=master)](https://travis-ci.org/asdf-community/asdf-kubectl)                                                                                         |
| kubectl-bindrole              | [looztra/asdf-kubectl-bindrole](https://github.com/looztra/asdf-kubectl-bindrole)                               | [![Build Status](https://travis-ci.org/looztra/asdf-kubectl-bindrole.svg?branch=master)](https://travis-ci.org/looztra/asdf-kubectl-bindrole)                                                                                     |
| kubectl-buildkit              | [ezcater/asdf-kubectl-buildkit](https://github.com/ezcater/asdf-kubectl-buildkit)                               | [![Build](https://github.com/ezcater/asdf-kubectl-buildkit/actions/workflows/build.yml/badge.svg)](https://github.com/ezcater/asdf-kubectl-buildkit/actions/workflows/build.yml)                                                  |
| kubectl-kots                  | [ganta/asdf-kubectl-kots](https://github.com/ganta/asdf-kubectl-kots)                                           | [![Build Status](https://github.com/ganta/asdf-kubectl-kots/actions/workflows/build.yml/badge.svg)](https://github.com/ganta/asdf-kubectl-kots/actions/workflows/build.yml)                                                       |
| kubectx                       | [wt0f/asdf-kubectx](https://gitlab.com/wt0f/asdf-kubectx)                                                       | [![pipeline status](https://gitlab.com/wt0f/asdf-kubectx/badges/master/pipeline.svg)](https://gitlab.com/wt0f/asdf-kubectx/-/commits/master)                                                                                      |
| Kubefedctl                    | [kvokka/asdf-kubefedctl](https://github.com/kvokka/asdf-kubefedctl)                                             | [![Build Status](https://travis-ci.org/kvokka/asdf-kubefedctl.svg?branch=master)](https://travis-ci.org/kvokka/asdf-kubefedctl)                                                                                                   |
| Kubelogin                     | [sechmann/asdf-kubelogin](https://github.com/sechmann/asdf-kubelogin)                                           | [![Build Status](https://github.com/Sechmann/asdf-kubelogin/actions/workflows/build.yml/badge.svg)](https://github.com/Sechmann/asdf-kubelogin/actions/workflows/build.yml)                                                       |
| Kubemqctl                     | [johnlayton/asdf-kubemqctl](https://github.com/johnlayton/asdf-kubemqctl)                                       | [![GitHub Actions Status](https://github.com/johnlayton/asdf-kubemqctl/workflows/main/badge.svg?branch=main)](https://github.com/johnlayton/asdf-kubemqctl/actions)                                                               |
| kubent                        | [virtualstaticvoid/asdf-kubent](https://github.com/virtualstaticvoid/asdf-kubent)                               | [![Build Status](https://github.com/virtualstaticvoid/asdf-kubent/actions/workflows/workflow.yml/badge.svg?branch=main)](https://github.com/virtualstaticvoid/asdf-kubent/actions/workflows/workflow.yml)                         |
| Kubergrunt                    | [NeoHsu/asdf-kubergrunt](https://github.com/NeoHsu/asdf-kubergrunt)                                             | [![Build](https://github.com/NeoHsu/asdf-kubergrunt/workflows/Build/badge.svg)](https://github.com/neohsu/asdf-kubergrunt/actions?query=workflow%3ABuild)                                                                         |
| Kubeseal                      | [stefansedich/asdf-kubeseal](https://github.com/stefansedich/asdf-kubeseal)                                     | [![Build Status](https://travis-ci.com/stefansedich/asdf-kubeseal.svg?branch=master)](https://travis-ci.com/stefansedich/asdf-kubeseal)                                                                                           |
| Kubesec                       | [vitalis/asdf-kubesec](https://github.com/vitalis/asdf-kubesec)                                                 | [![Build Status](https://travis-ci.org/vitalis/asdf-kubesec.svg?branch=master)](https://travis-ci.org/vitalis/asdf-kubesec)                                                                                                       |
| kubespy                       | [jfreeland/asdf-kubespy](https://github.com/jfreeland/asdf-kubespy)                                             | [![Build Status](https://github.com/jfreeland/asdf-kubespy/workflows/build/badge.svg)](https://github.com/jfreeland/asdf-kubespy/actions?query=workflow%3A%22build%22)                                                            |
| Kubeval                       | [stefansedich/asdf-kubeval](https://github.com/stefansedich/asdf-kubeval)                                       | [![Build Status](https://travis-ci.com/stefansedich/asdf-kubeval.svg?branch=master)](https://travis-ci.com/stefansedich/asdf-kubeval)                                                                                             |
| Kubie                         | [johnhamelink/asdf-kubie](https://github.com/johnhamelink/asdf-kubie)                                           | [![Build Status](https://travis-ci.com/johnhamelink/asdf-kubie.svg?branch=master)](https://travis-ci.com/johnhamelink/asdf-kubie)                                                                                                 |
| Kustomize                     | [Banno/asdf-kustomize](https://github.com/Banno/asdf-kustomize)                                                 | [![Build Status](https://travis-ci.com/Banno/asdf-kustomize.svg?branch=master)](https://travis-ci.com/Banno/asdf-kustomize)                                                                                                       |
| kuttl                         | [jimmidyson/asdf-kuttl](https://github.com/jimmidyson/asdf-kuttl)                                               | [![Build Status](https://github.com/jimmidyson/asdf-kuttl/workflows/ci/badge.svg?branch=main)](https://github.com/jimmidyson/asdf-kuttl/)                                                                                         |
| kwt                           | [vmware-tanzu/asdf-carvel](https://github.com/vmware-tanzu/asdf-carvel)                                         | [![Build Status](https://github.com/vmware-tanzu/asdf-carvel/workflows/test-all/badge.svg)](https://github.com/vmware-tanzu/asdf-carvel/actions)                                                                                  |
| lab                           | [particledecay/asdf-lab](https://github.com/particledecay/asdf-lab)                                             | [![Test Plugin](https://github.com/particledecay/asdf-lab/workflows/Plugin%20Test/badge.svg)](https://github.com/particledecay/asdf-lab/actions)                                                                                  |
| lazygit                       | [nklmilojevic/asdf-lazygit](https://github.com/nklmilojevic/asdf-lazygit)                                       | [![Build Status](https://github.com/nklmilojevic/asdf-lazygit/actions/workflows/build.yml/badge.svg)](https://github.com/nklmilojevic/asdf-lazygit/actions)                                                                       |
| Lean                          | [asdf-community/asdf-lean](https://github.com/asdf-community/asdf-lean)                                         | [![Build Status](https://github.com/asdf-community/asdf-lean/workflows/Main%20workflow/badge.svg?branch=master)](https://github.com/asdf-community/asdf-lean/actions)                                                             |
| Leiningen                     | [miorimmax/asdf-lein](https://github.com/miorimmax/asdf-lein)                                                   | [![Build Status](https://travis-ci.org/miorimmax/asdf-lein.svg?branch=master)](https://travis-ci.org/miorimmax/asdf-lein)                                                                                                         |
| Levant                        | [asdf-community/asdf-hashicorp](https://github.com/asdf-community/asdf-hashicorp)                               | [![Build](https://github.com/asdf-community/asdf-hashicorp/actions/workflows/workflow.yml/badge.svg)](https://github.com/asdf-community/asdf-hashicorp/actions/workflows/workflow.yml)                                            |
| LFE                           | [asdf-community/asdf-lfe](https://github.com/asdf-community/asdf-lfe)                                           | [![Build Status](https://travis-ci.org/asdf-community/asdf-lfe.svg?branch=master)](https://travis-ci.org/asdf-community/asdf-lfe)                                                                                                 |
| Link (system tools)           | [asdf-community/asdf-link](https://github.com/asdf-community/asdf-link)                                         | [![Build Status](https://travis-ci.org/asdf-community/asdf-link.svg?branch=master)](https://travis-ci.org/asdf-community/asdf-link)                                                                                               |
| Linkerd                       | [kforsthoevel/asdf-linkerd](https://github.com/kforsthoevel/asdf-linkerd)                                       | [![GitHub Actions Status](https://github.com/kforsthoevel/asdf-linkerd/workflows/CI/badge.svg?branch=main)](https://github.com/kforsthoevel/asdf-linkerd/actions)                                                                 |
| liqoctl                       | [pdemagny/asdf-liqoctl](https://github.com/pdemagny/asdf-liqoctl)                                               | [![Build Status](https://github.com/pdemagny/asdf-liqoctl/actions/workflows/build.yml/badge.svg)](https://github.com/pdemagny/asdf-liqoctl/actions)                                                                               |
| Litestream                    | [threkk/asdf-litestream](https://github.com/threkk/asdf-litestream)                                             | [![GitHub Actions Status](https://github.com/threkk/asdf-litestream/workflows/Build/badge.svg?branch=master)](https://github.com/threkk/asdf-litestream/actions)                                                                  |
| Logtalk                       | [LogtalkDotOrg/asdf-logtalk](https://github.com/LogtalkDotOrg/asdf-logtalk)                                     | [![Build Status](https://travis-ci.org/LogtalkDotOrg/asdf-logtalk.svg?branch=master)](https://travis-ci.org/LogtalkDotOrg/asdf-logtalk)                                                                                           |
| Loki-Logcli                   | [comdotlinux/asdf-loki-logcli](https://github.com/comdotlinux/asdf-loki-logcli)                                 | [![Build Status](https://github.com/comdotlinux/asdf-loki-logcli/workflows/Build/badge.svg)](https://github.com/comdotlinux/asdf-loki-logcli/actions)                                                                             |
| Lua                           | [Stratus3D/asdf-lua](https://github.com/Stratus3D/asdf-lua)                                                     | [![Build Status](https://travis-ci.org/Stratus3D/asdf-lua.svg?branch=master)](https://travis-ci.org/Stratus3D/asdf-lua)                                                                                                           |
| LuaJIT                        | [smashedtoatoms/asdf-luaJIT](https://github.com/smashedtoatoms/asdf-luaJIT)                                     | [![Build Status](https://github.com/smashedtoatoms/asdf-luaJIT/workflows/Build/badge.svg?branch=master)](https://github.com/smashedtoatoms/asdf-luaJIT/actions)                                                                   |
| Lucy                          | [cometkim/asdf-lucy](https://github.com/cometkim/asdf-lucy)                                                     | [![CI](https://github.com/cometkim/asdf-lucy/actions/workflows/ci.yml/badge.svg)](https://github.com/cometkim/asdf-lucy/actions/workflows/ci.yml)                                                                                 |
| mage                          | [mathew-fleisch/asdf-mage](https://github.com/mathew-fleisch/asdf-mage)                                         | [![Build Status](https://github.com/mathew-fleisch/asdf-mage/workflows/Build/badge.svg?branch=main)](https://github.com/mathew-fleisch/asdf-mage/actions)                                                                         |
| make                          | [yacchi/asdf-make](https://github.com/yacchi/asdf-make)                                                         | [![Build Status](https://github.com/yacchi/asdf-make/actions/workflows/build.yml/badge.svg)](https://github.com/yacchi/asdf-make/actions?query=workflow%3ABuild)                                                                  |
| mani                          | [anweber/asdf-mani](https://github.com/anweber/asdf-mani)                                                       | [![Build Status](https://github.com/anweber/asdf-mani/actions/workflows/build.yml/badge.svg)](https://github.com/anweber/asdf-mani/actions?query=workflow%3ABuild)                                                                |
| mark                          | [jfreeland/asdf-mark](https://github.com/jfreeland/asdf-mark)                                                   | [![Build Status](https://github.com/jfreeland/asdf-mark/workflows/build/badge.svg)](https://github.com/jfreeland/asdf-mark/actions?query=workflow%3Abuild)                                                                        |
| mask                          | [aaaaninja/asdf-mask](https://github.com/aaaaninja/asdf-mask)                                                   | [![Build Status](https://github.com/aaaaninja/asdf-mask/actions/workflows/build.yml/badge.svg)](https://github.com/aaaaninja/asdf-mask/actions/workflows/build.yml)                                                               |
| Maven                         | [halcyon/asdf-maven](https://github.com/halcyon/asdf-maven)                                                     | [![Build Status](https://travis-ci.org/halcyon/asdf-maven.svg?branch=master)](https://travis-ci.org/halcyon/asdf-maven)                                                                                                           |
| mdbook                        | [cipherstash/asdf-mdbook](https://github.com/cipherstash/asdf-mdbook)                                           | [![Code Health](https://github.com/cipherstash/asdf-mdbook/actions/workflows/test.yml/badge.svg?branch=main&event=push)](https://github.com/cipherstash/asdf-mdbook/actions)                                                      |
| mdbook-linkcheck              | [cipherstash/asdf-mdbook-linkcheck](https://github.com/cipherstash/asdf-mdbook-linkcheck)                       | [![Code Health](https://github.com/cipherstash/asdf-mdbook-linkcheck/actions/workflows/test.yml/badge.svg?branch=main&event=push)](https://github.com/cipherstash/asdf-mdbook-linkcheck/actions)                                  |
| melt                          | [chessmango/asdf-melt](https://github.com/chessmango/asdf-melt)                                                 | [![GitHub Actions Status](https://github.com/chessmango/asdf-melt/actions/workflows/build.yml/badge.svg)](https://github.com/chessmango/asdf-melt/actions)                                                                        |
| Memcached                     | [furkanural/asdf-memcached](https://github.com/furkanural/asdf-memcached)                                       | [![Build](https://github.com/furkanural/asdf-memcached/actions/workflows/build.yml/badge.svg?branch=main)](https://github.com/furkanural/asdf-memcached/actions/workflows/build.yml)                                              |
| Meson                         | [asdf-community/asdf-meson](https://github.com/asdf-community/asdf-meson)                                       | [![Build Status](https://github.com/asdf-community/asdf-meson/workflows/Main%20workflow/badge.svg?branch=master)](https://github.com/asdf-community/asdf-meson/actions)                                                           |
| Micronaut                     | [weibemoura/asdf-micronaut](https://github.com/weibemoura/asdf-micronaut)                                       | [![Build Status](https://travis-ci.org/weibemoura/asdf-micronaut.svg?branch=master)](https://travis-ci.org/weibemoura/asdf-micronaut)                                                                                             |
| Mill                          | [asdf-community/asdf-mill](https://github.com/asdf-community/asdf-mill)                                         | [![Build Status](https://travis-ci.org/asdf-community/asdf-mill.svg?branch=master)](https://travis-ci.org/asdf-community/asdf-mill)                                                                                               |
| Minikube                      | [alvarobp/asdf-minikube](https://github.com/alvarobp/asdf-minikube)                                             | [![Build Status](https://github.com/alvarobp/asdf-minikube/workflows/main/badge.svg)](https://github.com/alvarobp/asdf-minikube/actions)                                                                                          |
| Minio                         | [aeons/asdf-minio](https://github.com/aeons/asdf-minio)                                                         | [![Build Status](https://github.com/aeons/asdf-minio/actions/workflows/test.yml/badge.svg)](https://github.com/aeons/asdf-minio/actions)                                                                                          |
| Minio Client                  | [penpyt/asdf-mc](https://github.com/penpyt/asdf-mc)                                                             | [![Build Status](https://travis-ci.com/penpyt/asdf-mc.svg?branch=master)](https://travis-ci.org/penpyt/asdf-mc)                                                                                                                   |
| Minishift                     | [sqtran/asdf-minishift](https://github.com/sqtran/asdf-minishift)                                               | [![Build Status](https://github.com/sqtran/asdf-minishift/workflows/CI/badge.svg?branch=master)](https://github.com/sqtran/asdf-minishift)                                                                                        |
| Mint                          | [mint-lang/asdf-mint](https://github.com/mint-lang/asdf-mint)                                                   | [![Build Status](https://github.com/mint-lang/asdf-mint/actions/workflows/workflow.yml/badge.svg)](https://github.com/mint-lang/asdf-mint/actions)                                                                                |
| mitmproxy                     | [NeoHsu/asdf-mitmproxy](https://github.com/NeoHsu/asdf-mitmproxy)                                               | [![Build](https://github.com/NeoHsu/asdf-mitmproxy/workflows/Build/badge.svg)](https://github.com/neohsu/asdf-mitmproxy/actions?query=workflow%3ABuild)                                                                           |
| mkcert                        | [salasrod/asdf-mkcert](https://github.com/salasrod/asdf-mkcert)                                                 | [![Build Status](https://github.com/salasrod/asdf-mkcert/workflows/CI/badge.svg?branch=master)](https://github.com/salasrod/asdf-mkcert/actions)                                                                                  |
| mlton                         | [asdf-community/asdf-mlton](https://github.com/asdf-community/asdf-mlton)                                       | [![Main workflow](https://github.com/asdf-community/asdf-mlton/workflows/Main%20workflow/badge.svg?branch=master)](https://github.com/asdf-community/asdf-mlton/actions)                                                          |
| mockery                       | [cabify/asdf-mockery](https://github.com/cabify/asdf-mockery)                                                   | [![Build Status](https://travis-ci.org/cabify/asdf-mockery.svg?branch=master)](https://travis-ci.org/cabify/asdf-mockery)                                                                                                         |
| mongo-tools                   | [itspngu/asdf-mongo-tools](https://github.com/itspngu/asdf-mongo-tools)                                         | [![CI](https://github.com/itspngu/asdf-mongo-tools/workflows/CI/badge.svg)](https://github.com/itspngu/asdf-mongo-tools/actions)                                                                                                  |
| MongoDB                       | [sylph01/asdf-mongodb](https://github.com/sylph01/asdf-mongodb)                                                 | [![Build Status](https://travis-ci.org/sylph01/asdf-mongodb.svg?branch=master)](https://travis-ci.org/sylph01/asdf-mongodb)                                                                                                       |
| mongosh                       | [itspngu/asdf-mongosh](https://github.com/itspngu/asdf-mongosh)                                                 | [![CI](https://github.com/itspngu/asdf-mongosh/workflows/CI/badge.svg)](https://github.com/itspngu/asdf-mongosh/actions)                                                                                                          |
| mutanus                       | [soriur/asdf-mutanus](https://github.com/SoriUR/asdf-mutanus)                                                   | [![Build Status](https://github.com/SoriUR/asdf-mutanus/workflows/Build/badge.svg?branch=main)](https://github.com/SoriUR/asdf-mutanus/actions)                                                                                   |
| mvnd                          | [joschi/asdf-mvnd](https://github.com/joschi/asdf-mvnd)                                                         | [![GitHub Actions Status](https://github.com/joschi/asdf-mvnd/workflows/Main%20workflow/badge.svg?branch=master)](https://github.com/joschi/asdf-mvnd/actions)                                                                    |
| MySQL                         | [iroddis/asdf-mysql](https://github.com/iroddis/asdf-mysql)                                                     | [![Build Status](https://travis-ci.org/iroddis/asdf-mysql.svg?branch=master)](https://travis-ci.org/iroddis/asdf-mysql)                                                                                                           |
| nancy                         | [iilyak/asdf-nancy](https://github.com/iilyak/asdf-nancy)                                                       | [![Build Status](https://github.com/iilyak/asdf-nancy/actions/workflows/build.yml/badge.svg)](https://github.com/iilyak/asdf-nancy/actions/workflows/build.yml))                                                                  |
| Neko Virtual Machine          | [asdf-community/asdf-neko](https://github.com/asdf-community/asdf-neko)                                         | [![Main workflow](https://github.com/asdf-community/asdf-neko/workflows/Main%20workflow/badge.svg?branch=master)](https://github.com/asdf-community/asdf-neko/actions)                                                            |
| Neovim                        | [richin13/asdf-neovim](https://github.com/richin13/asdf-neovim)                                                 | [![Build Status](https://github.com/richin13/asdf-neovim/workflows/Main%20workflow/badge.svg)](https://github.com/richin13/asdf-neovim/workflows/Main%20workflow/badge.svg)                                                       |
| nerdctl                       | [dmpe/asdf-nerdctl](https://github.com/dmpe/asdf-nerdctl)                                                       | [![Build](https://github.com/dmpe/asdf-nerdctl/actions/workflows/build.yml/badge.svg?branch=main)](https://github.com/dmpe/asdf-nerdctl/actions/workflows/build.yml)                                                              |
| newrelic-cli                  | [NeoHsu/asdf-newrelic-cli](https://github.com/NeoHsu/asdf-newrelic-cli)                                         | [![Build](https://github.com/NeoHsu/asdf-newrelic-cli/workflows/Build/badge.svg)](https://github.com/neohsu/asdf-newrelic-cli/actions?query=workflow%3ABuild)                                                                     |
| nfpm                          | [nfpm](https://github.com/ORCID/asdf-nfpm)                                                                      | [![Build](https://github.com/ORCID/asdf-nfpm/actions/workflows/build.yml/badge.svg)](https://github.com/ORCID/asdf-nfpm/actions/workflows/build.yml)                                                                              |
| Nim                           | [asdf-community/asdf-nim](https://github.com/asdf-community/asdf-nim)                                           | [![Build Status](https://github.com/asdf-community/asdf-nim/workflows/Build/badge.svg)](https://github.com/asdf-community/asdf-nim/actions)                                                                                       |
| Ninja                         | [asdf-community/asdf-ninja](https://github.com/asdf-community/asdf-ninja)                                       | [![Build Status](https://github.com/asdf-community/asdf-ninja/workflows/Main%20workflow/badge.svg?branch=master)](https://github.com/asdf-community/asdf-ninja/actions)                                                           |
| Node.js                       | [asdf-vm/asdf-nodejs](https://github.com/asdf-vm/asdf-nodejs)                                                   | [![Build Status](https://travis-ci.org/asdf-vm/asdf-nodejs.svg?branch=master)](https://travis-ci.org/asdf-vm/asdf-nodejs)                                                                                                         |
| Nomad                         | [asdf-community/asdf-hashicorp](https://github.com/asdf-community/asdf-hashicorp)                               | [![Build](https://github.com/asdf-community/asdf-hashicorp/actions/workflows/workflow.yml/badge.svg)](https://github.com/asdf-community/asdf-hashicorp/actions/workflows/workflow.yml)                                            |
| nova                          | [elementalvoid/asdf-nova](https://github.com/elementalvoid/asdf-nova)                                           | [![GitHub Actions Status](https://github.com/elementalvoid/asdf-nova/workflows/Main%20workflow/badge.svg?branch=master)](https://github.com/elementalvoid/asdf-nova/actions)                                                      |
| NSC                           | [dex4er/asdf-nsc](https://github.com/dex4er/asdf-nsc)                                                           | [![CI](https://github.com/dex4er/asdf-nsc/actions/workflows/ci.yml/badge.svg)](https://github.com/dex4er/asdf-nsc/actions/workflows/ci.yml)                                                                                       |
| oc                            | [sqtran/asdf-oc](https://github.com/sqtran/asdf-oc)                                                             | [![Build Status](https://github.com/sqtran/asdf-oc/workflows/CI/badge.svg?branch=master)](https://github.com/sqtran/asdf-oc/actions)                                                                                              |
| OCaml                         | [asdf-community/asdf-ocaml](https://github.com/asdf-community/asdf-ocaml)                                       | [![Build Status](https://github.com/asdf-community/asdf-ocaml/workflows/Main%20workflow/badge.svg?branch=master)](https://github.com/asdf-community/asdf-ocaml/actions)                                                           |
| Odin                          | [jtakakura/asdf-odin](https://github.com/jtakakura/asdf-odin)                                                   | [![Build Status](https://github.com/jtakakura/asdf-odin/workflows/Build/badge.svg)](https://github.com/jtakakura/asdf-odin/actions?query=workflow%3ABuild)                                                                        |
| odo                           | [rm3l/asdf-odo](https://github.com/rm3l/asdf-odo)                                                               | [![Build status](https://github.com/rm3l/asdf-odo/workflows/Build/badge.svg?branch=main)](https://github.com/rm3l/asdf-odo/actions)                                                                                               |
| Okteto                        | [BradenM/asdf-okteto](https://github.com/BradenM/asdf-okteto)                                                   | [![Build Status](https://github.com/BradenM/asdf-okteto/workflows/Build/badge.svg?branch=master)](https://github.com/BradenM/asdf-okteto/actions)                                                                                 |
| om                            | [laidbackware/asdf-pivotal](https://github.com/laidbackware/asdf-pivotal)                                       | [![Build Status](https://github.com/laidbackware/asdf-pivotal/actions/workflows/test-om.yml/badge.svg?branch=main)](https://github.com/laidbackware/asdf-pivotal/actions/workflows/test-om.yml)                                   |
| OPA                           | [tochukwuvictor/asdf-opa](https://github.com/tochukwuvictor/asdf-opa)                                           | [![Build status](https://github.com/tochukwuvictor/asdf-opa/workflows/Build/badge.svg?branch=main)](https://github.com/tochukwuvictor/asdf-opa/actions)                                                                           |
| Opam                          | [asdf-community/asdf-opam](https://github.com/asdf-community/asdf-opam)                                         | [![Build status](https://github.com/asdf-community/asdf-opam/workflows/Main%20workflow/badge.svg?branch=master)](https://github.com/asdf-community/asdf-opam/actions)                                                             |
| openfaas-faas-cli             | [zekker6/asdf-faas-cli](https://github.com/zekker6/asdf-faas-cli)                                               | [![Build Status](https://github.com/zekker6/asdf-faas-cli/actions/workflows/test.yml/badge.svg)](https://github.com/zekker6/asdf-faas-cli/actions/workflows/test.yml)                                                             |
| OpenResty                     | [smashedtoatoms/asdf-openresty](https://github.com/smashedtoatoms/asdf-openresty)                               | [![Build Status](https://github.com/smashedtoatoms/asdf-openresty/workflows/Build/badge.svg?branch=master)](https://github.com/smashedtoatoms/asdf-openresty/actions)                                                             |
| opensearch                    | [randikabanura/asdf-opensearch](https://github.com/randikabanura/asdf-opensearch)                               | [![Build Status](https://github.com/randikabanura/asdf-opensearch/workflows/Build/badge.svg?branch=main)](https://github.com/randikabanura/asdf-opensearch/actions)                                                               |
| openshift-install             | [hhemied/asdf-openshift-install](https://github.com/hhemied/asdf-openshift-install)                             | [![Build Status](https://github.com/hhemied/asdf-openshift-install/actions/workflows/asdf-ci.yaml/badge.svg?branch=main)](https://github.com/hhemied/asdf-openshift-install/actions/workflows/asdf-ci.yaml)                       |
| Operator SDK                  | [Medium/asdf-operator-sdk](https://github.com/Medium/asdf-operator-sdk)                                         | [![Build Status](https://travis-ci.org/Medium/asdf-operator-sdk.svg?branch=master)](https://travis-ci.org/Medium/asdf-operator-sdk)                                                                                               |
| Opsgenie-lamp                 | [ORCID/asdf-opsgenie-lamp](https://github.com/ORCID/asdf-opsgenie-lamp)                                         | [![Build](https://github.com/ORCID/asdf-opsgenie-lamp/actions/workflows/build.yml/badge.svg)](https://github.com/ORCID/asdf-opsgenie-lamp/actions/workflows/build.yml)                                                            |
| Osm                           | [nlamirault/asdf-osm](https://github.com/nlamirault/asdf-osm)                                                   | [![GitHub Actions Status](https://github.com/nlamirault/asdf-osm/workflows/main/badge.svg?branch=master)](https://github.com/nlamirault/asdf-osm/actions)                                                                         |
| osqueryi                      | [davidecavestro/asdf-osqueryi](https://github.com/davidecavestro/asdf-osqueryi)                                 | [![Build Status](https://github.com/davidecavestro/asdf-osqueryi/actions/workflows/build.yml/badge.svg)](https://github.com/davidecavestro/asdf-osqueryi/actions/workflows/build.yml)                                             |
| pachctl                       | [abatilo/asdf-pachctl](https://github.com/abatilo/asdf-pachctl)                                                 | [![build](https://github.com/abatilo/asdf-pachctl/workflows/build/badge.svg)](https://github.com/abatilo/asdf-pachctl/actions?query=workflow%3A%22build%22)                                                                       |
| Packer                        | [asdf-community/asdf-hashicorp](https://github.com/asdf-community/asdf-hashicorp)                               | [![Build](https://github.com/asdf-community/asdf-hashicorp/actions/workflows/workflow.yml/badge.svg)](https://github.com/asdf-community/asdf-hashicorp/actions/workflows/workflow.yml)                                            |
| patat                         | [airtonix/asdf-patat](https://github.com/airtonix/asdf-patat)                                                   | [![Build](https://github.com/airtonix/asdf-patat/actions/workflows/build.yml/badge.svg)](https://github.com/airtonix/asdf-patat/actions/workflows/build.yml)                                                                      |
| peco                          | [asdf-community/asdf-peco](https://github.com/asdf-community/asdf-peco)                                         | [![Build Status](https://github.com/asdf-community/asdf-peco/workflows/Main%20workflow/badge.svg?branch=master)](https://github.com/asdf-community/asdf-peco/actions)                                                             |
| pdm                           | [1oglop1/asdf-pdm](https://github.com/1oglop1/asdf-pdm)                                                         | [![Build Status](https://github.com/1oglop1/asdf-pdm/actions/workflows/build.yml/badge.svg)](https://github.com/1oglop1/asdf-pdm/actions)                                                                                         |
| Perl                          | [ouest/asdf-perl](https://github.com/ouest/asdf-perl)                                                           | [![Build Status](https://travis-ci.org/ouest/asdf-perl.svg?branch=master)](https://travis-ci.org/ouest/asdf-perl)                                                                                                                 |
| PHP                           | [asdf-community/asdf-php](https://github.com/asdf-community/asdf-php)                                           | [![Build status](https://github.com/asdf-community/asdf-php/workflows/Main%20workflow/badge.svg?branch=master)](https://github.com/asdf-community/asdf-php/actions)                                                               |
| pint                          | [sam-burrell/asdf-pint](https://github.com/sam-burrell/asdf-pint)                                               | [![Build Status](https://github.com/sam-burrell/asdf-pint/workflows/ci/badge.svg?branch=main)](https://github.com/sam-burrell/asdf-pint/actions/workflows/ci.yml)                                                                 |
| pivnet                        | [laidbackware/asdf-pivotal](https://github.com/laidbackware/asdf-pivotal)                                       | [![Build Status](https://github.com/laidbackware/asdf-pivotal/actions/workflows/test-pivnet.yml/badge.svg?branch=main)](https://github.com/laidbackware/asdf-pivotal/actions/workflows/test-pivnet.yml)                           |
| Please                        | [asdf-community/asdf-please](https://github.com/asdf-community/asdf-please)                                     | [![Build status](https://github.com/asdf-community/asdf-please/workflows/Build/badge.svg?branch=master)](https://github.com/asdf-community/asdf-please/actions)                                                                   |
| Pluto                         | [FairwindsOps/pluto](https://github.com/FairwindsOps/asdf-pluto)                                                | [![GitHub Actions Status](https://github.com/FairwindsOps/asdf-pluto/workflows/master/badge.svg?branch=master)](https://github.com/FairwindsOps/asdf-pluto/actions)                                                               |
| pnpm                          | [jonathanmorley/asdf-pnpm](https://github.com/jonathanmorley/asdf-pnpm)                                         | [![GitHub Actions Status](https://github.com/jonathanmorley/asdf-pnpm/workflows/ASDF%20CI/badge.svg)](https://github.com/jonathanmorley/asdf-pnpm/actions)                                                                        |
| Poetry                        | [asdf-community/asdf-poetry](https://github.com/asdf-community/asdf-poetry)                                     | [![GitHub Actions Status](https://github.com/asdf-community/asdf-poetry/workflows/Main%20workflow/badge.svg?branch=master)](https://github.com/asdf-community/asdf-poetry/actions)                                                |
| Polaris                       | [particledecay/asdf-polaris](https://github.com/particledecay/asdf-polaris)                                     | [![Test Plugin](https://github.com/particledecay/asdf-polaris/workflows/Plugin%20Test/badge.svg)](https://github.com/particledecay/asdf-polaris/actions)                                                                          |
| Popeye                        | [nlamirault/asdf-popeye](https://github.com/nlamirault/asdf-popeye)                                             | [![GitHub Actions Status](https://github.com/nlamirault/asdf-popeye/workflows/main/badge.svg?branch=master)](https://github.com/nlamirault/asdf-popeye/actions)                                                                   |
| Postgres                      | [smashedtoatoms/asdf-postgres](https://github.com/smashedtoatoms/asdf-postgres)                                 | [![Build Status](https://github.com/smashedtoatoms/asdf-postgres/workflows/Build/badge.svg?branch=master)](https://github.com/smashedtoatoms/asdf-postgres/actions)                                                               |
| PowerShell                    | [daveneeley/asdf-powershell-core](https://github.com/daveneeley/asdf-powershell-core)                           | [![Build Status](https://github.com/daveneeley/asdf-powershell-core/actions/workflows/build.yml/badge.svg)](https://github.com/daveneeley/asdf-powershell-core/actions/workflows/build.yml)                                       |
| pre-commit                    | [jonathanmorley/asdf-pre-commit](https://github.com/jonathanmorley/asdf-pre-commit)                             | [![GitHub Actions Status](https://github.com/jonathanmorley/asdf-pre-commit/workflows/ASDF%20CI/badge.svg)](https://github.com/jonathanmorley/asdf-pre-commit/actions)                                                            |
| protoc                        | [paxosglobal/asdf-protoc](https://github.com/paxosglobal/asdf-protoc)                                           | [![Build Status](https://travis-ci.com/paxosglobal/asdf-protoc.svg?branch=master)](https://travis-ci.com/paxosglobal/asdf-protoc)                                                                                                 |
| protoc-gen-grpc-web           | [pbr0ck3r/asdf-protoc-gen-grpc-web](https://github.com/pbr0ck3r/asdf-protoc-gen-grpc-web)                       | [![Build Status](https://github.com/pbr0ck3r/asdf-protoc-gen-grpc-web/workflows/Build/badge.svg)](https://github.com/pbr0ck3r/asdf-protoc-gen-grpc-web/actions/workflows/build.yml)                                               |
| protoc-gen-go-grpc            | [pbr0ck3r/asdf-protoc-gen-go-grpc](https://github.com/pbr0ck3r/asdf-protoc-gen-go-grpc)                         | [![Build Status](https://github.com/pbr0ck3r/asdf-protoc-gen-go-grpc/workflows/Build/badge.svg)](https://github.com/pbr0ck3r/asdf-protoc-gen-go-grpc/actions/workflows/build.yml)                                                 |
| protoc-gen-go                 | [pbr0ck3r/asdf-protoc-gen-go](https://github.com/pbr0ck3r/asdf-protoc-gen-go)                                   | [![Build Status](https://github.com/pbr0ck3r/asdf-protoc-gen-go/workflows/Build/badge.svg)](https://github.com/pbr0ck3r/asdf-protoc-gen-go/actions/workflows/build.yml)                                                           |
| protoc-gen-js                 | [pbr0ck3r/asdf-protoc-gen-js](https://github.com/pbr0ck3r/asdf-protoc-gen-js)                                   | [![Build Status](https://github.com/pbr0ck3r/asdf-protoc-gen-js/workflows/Build/badge.svg)](https://github.com/pbr0ck3r/asdf-protoc-gen-js/actions/workflows/build.yml)                                                           |
| protolint                     | [spencergilbert/asdf-protolint](https://github.com/spencergilbert/asdf-protolint)                               | [![Build](https://github.com/spencergilbert/asdf-protolint/actions/workflows/build.yml/badge.svg)](https://github.com/spencergilbert/asdf-protolint/actions/workflows/build.yml)                                                  |
| psc-package                   | [nsaunders/asdf-psc-package](https://github.com/nsaunders/asdf-psc-package)                                     | [![Build Status](https://github.com/nsaunders/asdf-psc-package/workflows/Build/badge.svg)](https://github.com/nsaunders/asdf-psc-package/actions)                                                                                 |
| Pulumi                        | [canha/asdf-pulumi](https://github.com/canha/asdf-pulumi)                                                       | [![Build Status](https://travis-ci.org/canha/asdf-pulumi.svg?branch=master)](https://travis-ci.org/canha/asdf-pulumi)                                                                                                             |
| purerl                        | [GoNZooo/asdf-purerl](https://github.com/GoNZooo/asdf-purerl)                                                   | [![Build Status](https://github.com/GoNZooo/asdf-purerl/workflows/Build/badge.svg)](https://github.com/GoNZooo/asdf-purerl/actions)                                                                                               |
| PureScript                    | [nsaunders/asdf-purescript](https://github.com/nsaunders/asdf-purescript)                                       | [![Build Status](https://github.com/nsaunders/asdf-purescript/workflows/Build/badge.svg)](https://github.com/nsaunders/asdf-purescript/actions)                                                                                   |
| Purty                         | [nsaunders/asdf-purty](https://github.com/nsaunders/asdf-purty)                                                 | [![Build Status](https://github.com/nsaunders/asdf-purty/workflows/Build/badge.svg)](https://github.com/nsaunders/asdf-purty/actions)                                                                                             |
| Python                        | [danhper/asdf-python](https://github.com/danhper/asdf-python)                                                   | [![Build Status](https://travis-ci.org/danhper/asdf-python.svg?branch=master)](https://travis-ci.org/danhper/asdf-python)                                                                                                         |
| Quarkus CLI                   | [asdf-community/asdf-quarkus](https://github.com/asdf-community/asdf-quarkus)                                   | [![Build](https://github.com/asdf-community/asdf-quarkus/actions/workflows/build.yml/badge.svg)](https://github.com/asdf-community/asdf-quarkus/actions/workflows/build.yml)                                                      |
| R                             | [asdf-community/asdf-r](https://github.com/asdf-community/asdf-r)                                               | [![Build Status](https://github.com/asdf-community/asdf-r/workflows/Main%20workflow/badge.svg?branch=master)](https://github.com/asdf-community/asdf-r/actions/workflows/workflow.yml)                                            |
| RabbitMQ                      | [w-sanches/asdf-rabbitmq](https://github.com/w-sanches/asdf-rabbitmq)                                           | [![Build Status](https://travis-ci.org/w-sanches/asdf-rabbitmq.svg?branch=master)](https://travis-ci.org/w-sanches/asdf-rabbitmq)                                                                                                 |
| Racket                        | [asdf-community/asdf-racket](https://github.com/asdf-community/asdf-racket)                                     | [![Build Status](https://travis-ci.org/asdf-community/asdf-racket.svg?branch=master)](https://travis-ci.org/asdf-community/asdf-racket)                                                                                           |
| Raku                          | [m-dango/asdf-raku](https://github.com/m-dango/asdf-raku)                                                       | [![Build Status](https://github.com/m-dango/asdf-raku/actions/workflows/main.yml/badge.svg?branch=main)](https://github.com/m-dango/asdf-raku/actions/workflows/main.yml?query=branch%3Amain++)                                   |
| Rancher                       | [abinet/asdf-rancher](https://github.com/abinet/asdf-rancher)                                                   | [![Build Status](https://travis-ci.org/abinet/asdf-rancher.svg?branch=master)](https://travis-ci.org/abinet/asdf-rancher)                                                                                                         |
| Rbac-lookup                   | [looztra/asdf-rbac-lookup](https://github.com/looztra/asdf-rbac-lookup)                                         | [![Build Status](https://travis-ci.org/looztra/asdf-rbac-lookup.svg?branch=master)](https://travis-ci.org/looztra/asdf-rbac-lookup)                                                                                               |
| Rclone                        | [johnlayton/asdf-rclone](https://github.com/johnlayton/asdf-rclone)                                             | [![GitHub Actions Status](https://github.com/johnlayton/asdf-rclone/workflows/main/badge.svg?branch=master)](https://github.com/johnlayton/asdf-rclone/actions)                                                                   |
| Rebar                         | [Stratus3D/asdf-rebar](https://github.com/Stratus3D/asdf-rebar)                                                 | [![Build Status](https://travis-ci.org/Stratus3D/asdf-rebar.svg?branch=master)](https://travis-ci.org/Stratus3D/asdf-rebar)                                                                                                       |
| Redis                         | [smashedtoatoms/asdf-redis](https://github.com/smashedtoatoms/asdf-redis)                                       | [![Build Status](https://github.com/smashedtoatoms/asdf-redis/workflows/Build/badge.svg?branch=master)](https://github.com/smashedtoatoms/asdf-redis/actions)                                                                     |
| Redis-cli                     | [NeoHsu/asdf-redis-cli](https://github.com/NeoHsu/asdf-redis-cli)                                               | [![Build](https://github.com/NeoHsu/asdf-redis-cli/workflows/Build/badge.svg)](https://github.com/neohsu/asdf-redis-cli/actions?query=workflow%3ABuild)                                                                           |
| redo                          | [chessmango/asdf-redo](https://github.com/chessmango/asdf-redo)                                                 | [![GitHub Actions Status](https://github.com/chessmango/asdf-redo/actions/workflows/build.yml/badge.svg)](https://github.com/chessmango/asdf-redo/actions)                                                                        |
| redskyctl                     | [sudermanjr/asdf-redskyctl](https://github.com/sudermanjr/asdf-redskyctl)                                       | [![Build Status](https://github.com/sudermanjr/asdf-redskyctl/workflows/master/badge.svg?branch=master)](https://github.com/sudermanjr/asdf-redskyctl/actions)                                                                    |
| Reg                           | [looztra/asdf-reg](https://github.com/looztra/asdf-reg)                                                         | [![Build Status](https://travis-ci.org/looztra/asdf-reg.svg?branch=master)](https://travis-ci.org/looztra/asdf-reg)                                                                                                               |
| regctl                        | [ORCID/asdf-regctl](https://github.com/ORCID/asdf-regctl)                                                       | [![Build](https://github.com/ORCID/asdf-regctl/actions/workflows/build.yml/badge.svg)](https://github.com/ORCID/asdf-regctl/actions/workflows/build.yml)                                                                          |
| richgo                        | [paxosglobal/asdf-richgo](https://github.com/paxosglobal/asdf-richgo)                                           | [![Build Status](https://travis-ci.org/paxosglobal/asdf-richgo.svg?branch=master)](https://travis-ci.org/paxosglobal/asdf-richgo)                                                                                                 |
| Riff                          | [abinet/asdf-riff](https://github.com/abinet/asdf-riff)                                                         | [![Build Status](https://travis-ci.org/abinet/asdf-riff.svg?branch=master)](https://travis-ci.org/abinet/asdf-riff)                                                                                                               |
| ripgrep                       | [wt0f/asdf-ripgrep](https://gitlab.com/wt0f/asdf-ripgrep)                                                       | [![pipeline status](https://gitlab.com/wt0f/asdf-ripgrep/badges/master/pipeline.svg)](https://gitlab.com/wt0f/asdf-ripgrep/-/commits/master)                                                                                      |
| RKE                           | [particledecay/asdf-rke](https://github.com/particledecay/asdf-rke)                                             | [![Build Status](https://travis-ci.org/particledecay/asdf-rke.svg?branch=master)](https://travis-ci.org/particledecay/asdf-rke)                                                                                                   |
| rstash                        | [carlduevel/asdf-rstash](https://github.com/carlduevel/asdf-rstash)                                             | [![Build Status](https://github.com/carlduevel/asdf-rstash/actions/workflows/build.yml/badge.svg?branch=main)](https://github.com/carlduevel/asdf-rstash/actions/workflows/build.yml)                                             |
| rlwrap                        | [asdf-community/asdf-rlwrap](https://github.com/asdf-community/asdf-rlwrap)                                     | [![Main workflow](https://github.com/asdf-community/asdf-rlwrap/workflows/Main%20workflow/badge.svg?branch=master)](https://github.com/asdf-community/asdf-rlwrap/actions)                                                        |
| Ruby                          | [asdf-vm/asdf-ruby](https://github.com/asdf-vm/asdf-ruby)                                                       | [![Build Status](https://travis-ci.org/asdf-vm/asdf-ruby.svg?branch=master)](https://travis-ci.org/asdf-vm/asdf-ruby)                                                                                                             |
| Rust                          | [code-lever/asdf-rust](https://github.com/code-lever/asdf-rust)                                                 | [![Build Status](https://travis-ci.org/code-lever/asdf-rust.svg?branch=master)](https://travis-ci.org/code-lever/asdf-rust)                                                                                                       |
| rust-analyzer                 | [Xyven1/asdf-rust-analyzer](https://github.com/Xyven1/asdf-rust-analyzer)                                       | [![Build Status](https://github.com/Xyven1/asdf-rust-analyzer/workflows/plugin%20test/badge.svg)](https://github.com/Xyven1/asdf-rust-analyzer/actions)                                                                           |
| saml2aws                      | [elementalvoid/asdf-saml2aws](https://github.com/elementalvoid/asdf-saml2aws)                                   | [![GitHub Actions Status](https://github.com/elementalvoid/asdf-saml2aws/workflows/Main%20workflow/badge.svg?branch=master)](https://github.com/elementalvoid/asdf-saml2aws/actions)                                              |
| SBT                           | [bram2000/asdf-sbt](https://github.com/bram2000/asdf-sbt)                                                       | [![Build Status](https://travis-ci.org/bram2000/asdf-sbt.svg?branch=master)](https://travis-ci.org/bram2000/asdf-sbt)                                                                                                             |
| Scala                         | [asdf-community/asdf-scala](https://github.com/asdf-community/asdf-scala)                                       | [![Build Status](https://travis-ci.org/asdf-community/asdf-scala.svg?branch=master)](https://travis-ci.org/asdf-community/asdf-scala)                                                                                             |
| scaleway-cli                  | [albarralnunez/asdf-plugin-scaleway-cli](https://github.com/albarralnunez/asdf-plugin-scaleway-cli)             | [![Build Status](https://github.com/albarralnunez/asdf-plugin-scaleway-cli/workflows/Build/badge.svg)](https://github.com/albarralnunez/asdf-plugin-scaleway-cli/workflows)                                                       |
| sccache                       | [emersonmx/asdf-sccache](https://github.com/emersonmx/asdf-sccache)                                             | [![Build Status](https://github.com/emersonmx/asdf-sccache/workflows/Build/badge.svg)](https://github.com/emersonmx/asdf-sccache/actions)                                                                                         |
| Scenery                       | [skyzyx/asdf-scenery](https://github.com/skyzyx/asdf-scenery)                                                   | [![Build Status](https://travis-ci.org/skyzyx/asdf-scenery.svg?branch=master)](https://travis-ci.org/skyzyx/asdf-scenery)                                                                                                         |
| schemacrawler                 | [davidecavestro/asdf-schemacrawler](https://github.com/davidecavestro/asdf-schemacrawler)                       | [![Build Status](https://github.com/davidecavestro/asdf-schemacrawler/actions/workflows/build.yml/badge.svg)](https://github.com/davidecavestro/asdf-schemacrawler/actions/workflows/build.yml)                                   |
| Semgrep                       | [Brentjanderson/asdf-semgrep](https://github.com/Brentjanderson/asdf-semgrep)                                   | [![CI](https://github.com/brentjanderson/asdf-semgrep/actions/workflows/ci.yml/badge.svg)](https://github.com/brentjanderson/asdf-semgrep/actions/workflows/ci.yml)                                                               |
| semtag                        | [junminahn/asdf-semtag](https://github.com/junminahn/asdf-semtag)                                               | [![Build Status](https://github.com/junminahn/asdf-semtag/workflows/Build/badge.svg?branch=main)](https://github.com/junminahn/asdf-semtag/actions)                                                                               |
| semver                        | [mathew-fleisch/asdf-semver](https://github.com/mathew-fleisch/asdf-semver)                                     | [![Build Status](https://github.com/mathew-fleisch/asdf-semver/workflows/Build/badge.svg?branch=main)](https://github.com/mathew-fleisch/asdf-semver/actions)                                                                     |
| Sentinel                      | [asdf-community/asdf-hashicorp](https://github.com/asdf-community/asdf-hashicorp)                               | [![Build](https://github.com/asdf-community/asdf-hashicorp/actions/workflows/workflow.yml/badge.svg)](https://github.com/asdf-community/asdf-hashicorp/actions/workflows/workflow.yml)                                            |
| Serf                          | [asdf-community/asdf-hashicorp](https://github.com/asdf-community/asdf-hashicorp)                               | [![Build](https://github.com/asdf-community/asdf-hashicorp/actions/workflows/workflow.yml/badge.svg)](https://github.com/asdf-community/asdf-hashicorp/actions/workflows/workflow.yml)                                            |
| Shellcheck                    | [luizm/asdf-shellcheck](https://github.com/luizm/asdf-shellcheck)                                               | [![Build Status](https://github.com/luizm/asdf-shellcheck/actions/workflows/build.yml/badge.svg?branch=master)](https://github.com/luizm/asdf-shellcheck/actions)                                                                 |
| Shellspec                     | [poikilotherm/asdf-shellspec](https://github.com/poikilotherm/asdf-shellspec)                                   | [![Build Status](https://github.com/poikilotherm/asdf-shellspec/workflows/Main/badge.svg?branch=main)](https://github.com/poikilotherm/asdf-shellspec/actions)                                                                    |
| Shfmt                         | [luizm/asdf-shfmt](https://github.com/luizm/asdf-shfmt)                                                         | [![Build Status](https://github.com/luizm/asdf-shfmt/actions/workflows/ci.yml/badge.svg)](https://github.com/luizm/asdf-shfmt/actions/workflows/ci.yml)                                                                           |
| Sinker                        | [elementalvoid/asdf-sinker](https://github.com/elementalvoid/asdf-sinker)                                       | [![GitHub Actions Status](https://github.com/elementalvoid/asdf-sinker/workflows/Main%20workflow/badge.svg?branch=master)](https://github.com/elementalvoid/asdf-sinker/actions)                                                  |
| Skaffold                      | [nklmilojevic/asdf-skaffold](https://github.com/nklmilojevic/asdf-skaffold)                                     | [![Build Status](https://github.com/nklmilojevic/asdf-skaffold/actions/workflows/build.yml/badge.svg)](https://github.com/nklmilojevic/asdf-skaffold/actions)                                                                     |
| skate                         | [chessmango/asdf-skate](https://github.com/chessmango/asdf-skate)                                               | [![GitHub Actions Status](https://github.com/chessmango/asdf-skate/actions/workflows/build.yml/badge.svg)](https://github.com/chessmango/asdf-skate/actions)                                                                      |
| Sloth                         | [slok/asdf-sloth](https://github.com/slok/asdf-sloth)                                                           | [![Build Status](https://github.com/slok/asdf-sloth/actions/workflows/ci.yml/badge.svg)](https://github.com/slok/asdf-sloth/actions)                                                                                              |
| SML/NJ                        | [samontea/asdf-smlnj](https://github.com/samontea/asdf-smlnj)                                                   | [![Build Status](https://travis-ci.org/samontea/asdf-smlnj.svg?branch=master)](https://travis-ci.org/samontea/asdf-smlnj)                                                                                                         |
| Snyk                          | [nirfuchs/asdf-snyk](https://github.com/nirfuchs/asdf-snyk)                                                     | [![Build Status](https://github.com/nirfuchs/asdf-snyk/workflows/CI/badge.svg?branch=master)](https://github.com/nirfuchs/asdf-snyk/actions)                                                                                      |
| soft-serve                    | [chessmango/asdf-soft-serve](https://github.com/chessmango/asdf-soft-serve)                                     | [![GitHub Actions Status](https://github.com/chessmango/asdf-soft-serve/actions/workflows/build.yml/badge.svg)](https://github.com/chessmango/asdf-soft-serve/actions)                                                            |
| Solidity                      | [diegodorado/asdf-solidity](https://github.com/diegodorado/asdf-solidity)                                       | [![Build Status](https://api.travis-ci.com/diegodorado/asdf-solidity.svg)](https://travis-ci.com/github/diegodorado/asdf-solidity)                                                                                                |
| Sops                          | [feniix/asdf-sops](https://github.com/feniix/asdf-sops)                                                         | [![Build Status](https://travis-ci.org/feniix/asdf-sops.svg?branch=master)](https://travis-ci.org/feniix/asdf-sops)                                                                                                               |
| sopstool                      | [elementalvoid/asdf-sopstool](https://github.com/elementalvoid/asdf-sopstool)                                   | [![GitHub Actions Status](https://github.com/elementalvoid/asdf-sopstool/workflows/Main%20workflow/badge.svg?branch=master)](https://github.com/elementalvoid/asdf-sopstool/actions)                                              |
| Sourcery                      | [younke/asdf-sourcery](https://github.com/younke/asdf-sourcery)                                                 | [![Build Status](https://github.com/younke/asdf-sourcery/workflows/Build/badge.svg?branch=master)](https://github.com/younke/asdf-sourcery/actions)                                                                               |
| Spago                         | [nsaunders/asdf-spago](https://github.com/nsaunders/asdf-spago)                                                 | [![Build Status](https://github.com/nsaunders/asdf-spago/workflows/Build/badge.svg)](https://github.com/nsaunders/asdf-spago/actions)                                                                                             |
| Spectral                      | [vbyrd/asdf-spectral](https://github.com/vbyrd/asdf-spectral)                                                   | [![Build Status](https://github.com/vbyrd/asdf-spectral/workflows/Build/badge.svg)](https://github.com/vbyrd/asdf-spectral/actions)                                                                                               |
| Spin                          | [pavloos/asdf-spin](https://github.com/pavloos/asdf-spin)                                                       | [![Build Status](https://github.com/pavloos/asdf-spin/workflows/Build/badge.svg?branch=main)](https://github.com/pavloos/asdf-spin/actions)                                                                                       |
| Spring Boot CLI               | [joschi/asdf-spring-boot](https://github.com/joschi/asdf-spring-boot)                                           | [![Main workflow](https://github.com/joschi/asdf-spring-boot/workflows/Main%20workflow/badge.svg?branch=main)](https://github.com/joschi/asdf-spring-boot/actions)                                                                |
| Spruce                        | [woneill/asdf-spruce](https://github.com/woneill/asdf-spruce)                                                   | [![Build Status](https://github.com/woneill/asdf-spruce/workflows/Build/badge.svg)](https://github.com/woneill/asdf-spruce/actions)                                                                                               |
| sqldef                        | [cometkim/asdf-sqldef](https://github.com/cometkim/asdf-sqldef)                                                 | [![CI](https://github.com/cometkim/asdf-sqldef/actions/workflows/ci.yml/badge.svg)](https://github.com/cometkim/asdf-sqldef/actions/workflows/ci.yml)                                                                             |
|                               |
| SQLite                        | [cLupus/asdf-sqlite](https://github.com/cLupus/asdf-sqlite)                                                     | [![Build Status](https://travis-ci.org/cLupus/asdf-sqlite.svg?branch=master)](https://travis-ci.org/cLupus/asdf-sqlite)                                                                                                           |
| Stack                         | [sestrella/asdf-ghcup](https://github.com/sestrella/asdf-ghcup)                                                 | [![CI](https://github.com/sestrella/asdf-ghcup/actions/workflows/ci.yml/badge.svg)](https://github.com/sestrella/asdf-ghcup/actions/workflows/ci.yml)                                                                             |
| starboard                     | [zufardhiyaulhaq/asdf-starboard](https://github.com/zufardhiyaulhaq/asdf-starboard)                             | [![Build](https://github.com/zufardhiyaulhaq/asdf-starboard/actions/workflows/build.yml/badge.svg)](https://github.com/zufardhiyaulhaq/asdf-starboard/actions/workflows/build.yml)                                                |
| starport                      | [nikever/asdf-starport](https://github.com/nikever/asdf-starport)                                               | [![Build Status](https://github.com/nikever/asdf-starport/workflows/Build/badge.svg)](https://github.com/nikever/asdf-starport/actions)                                                                                           |
| starship                      | [grimoh/asdf-starship](https://github.com/grimoh/asdf-starship)                                                 | [![GitHub Actions Status](https://github.com/grimoh/asdf-starship/workflows/Main%20workflow/badge.svg?branch=master)](https://github.com/grimoh/asdf-starship/actions)                                                            |
| steampipe                     | [carnei-ro/asdf-steampipe](https://github.com/carnei-ro/asdf-steampipe)                                         | [![Build Status](https://github.com/carnei-ro/asdf-steampipe/workflows/Build/badge.svg?branch=main)](https://github.com/carnei-ro/asdf-steampipe/actions)                                                                         |
| Steel Bank Common Lisp (sbcl) | [smashedtoatoms/asdf-sbcl](https://github.com/smashedtoatoms/asdf-sbcl)                                         | [![Build Status](https://github.com/smashedtoatoms/asdf-sbcl/workflows/Build/badge.svg?branch=main)](https://github.com/smashedtoatoms/asdf-sbcl/actions)                                                                         |
| step                          | [log2/asdf-step](https://github.com/log2/asdf-step)                                                             | [![Build](https://github.com/log2/asdf-step/actions/workflows/build.yml/badge.svg)](https://github.com/log2/asdf-step/actions/workflows/build.yml)                                                                                |
| Stern                         | [looztra/asdf-stern](https://github.com/looztra/asdf-stern)                                                     | [![Build Status](https://travis-ci.org/looztra/asdf-stern.svg?branch=master)](https://travis-ci.org/looztra/asdf-stern)                                                                                                           |
| stripe-cli                    | [offbyone/asdf-stripe](https://github.com/offbyone/asdf-stripe)                                                 | [![Build Status](https://github.com/offbyone/asdf-stripe/workflows/ASDF%20CI/badge.svg)](https://github.com/offbyone/asdf-stripe/actions)                                                                                         |
| stylua                        | [jc00ke/asdf-stylua](https://github.com/jc00ke/asdf-stylua)                                                     | [![Build Status](https://github.com/jc00ke/asdf-stylua/workflows/Build/badge.svg?branch=main)](https://github.com/jc00ke/asdf-stylua/actions)                                                                                     |
| svu                           | [asdf-community/asdf-svu](https://github.com/asdf-community/asdf-svu)                                           | [![Main workflow](https://github.com/asdf-community/asdf-svu/actions/workflows/workflow.yaml/badge.svg)](https://github.com/asdf-community/asdf-svu/actions/workflows/workflow.yaml)                                              |
| swag                          | [behoof4mind/asdf-swag](https://github.com/behoof4mind/asdf-swag)                                               | [![Build Status](https://github.com/behoof4mind/asdf-swag/workflows/Build/badge.svg?branch=main)](https://github.com/behoof4mind/asdf-swag/actions)                                                                               |
| SwiftFormat                   | [younke/asdf-swiftformat](https://github.com/younke/asdf-swiftformat)                                           | [![Build Status](https://github.com/younke/asdf-swiftformat/workflows/Build/badge.svg?branch=master)](https://github.com/younke/asdf-swiftformat/actions)                                                                         |
| SwiftGen                      | [younke/asdf-swiftgen](https://github.com/younke/asdf-swiftgen)                                                 | [![Build Status](https://github.com/younke/asdf-swiftgen/workflows/Build/badge.svg?branch=master)](https://github.com/younke/asdf-swiftgen/actions)                                                                               |
| Swiftlint                     | [klundberg/asdf-swiftlint](https://github.com/klundberg/asdf-swiftlint)                                         | [![Build Status](https://travis-ci.org/klundberg/asdf-swiftlint.svg?branch=master)](https://travis-ci.org/klundberg/asdf-swiftlint)                                                                                               |
| SWIProlog                     | [mracos/asdf-swiprolog](https://github.com/mracos/asdf-swiprolog)                                               | [![Build Status](https://travis-ci.org/mracos/asdf-swiprolog.svg?branch=master)](https://travis-ci.org/mracos/asdf-swiprolog)                                                                                                     |
| syft                          | [davidgp1701/asdf-syft](https://github.com/davidgp1701/asdf-syft)                                               | [![GitHub Actions Status](https://github.com/davidgp1701/asdf-syft/workflows/Build/badge.svg?branch=main)](https://github.com/davidgp1701/asdf-syft/actions)                                                                      |
| syncher                       | [nwillc/syncher](https://github.com/nwillc/syncher)                                                             | [![GitHub Actions Status](https://github.com/nwillc/syncher/workflows/CI/badge.svg?branch=master)](https://github.com/nwillc/syncher/actions)                                                                                     |
| Talos                         | [particledecay/asdf-talos](https://github.com/particledecay/asdf-talos)                                         | [![Test Plugin](https://github.com/particledecay/asdf-talos/workflows/Plugin%20Test/badge.svg)](https://github.com/particledecay/asdf-talos/actions)                                                                              |
| Tanka                         | [trotttrotttrott/asdf-tanka](https://github.com/trotttrotttrott/asdf-tanka)                                     | [![Build Status](https://travis-ci.org/trotttrotttrott/asdf-tanka.svg?branch=master)](https://travis-ci.org/trotttrotttrott/asdf-tanka)                                                                                           |
| Task                          | [particledecay/asdf-task](https://github.com/particledecay/asdf-task)                                           | [![Test Plugin](https://github.com/particledecay/asdf-task/workflows/Plugin%20Test/badge.svg)](https://github.com/particledecay/asdf-task/actions)                                                                                |
| Tekton-cli                    | [johnhamelink/asdf-tekton-cli](https://github.com/johnhamelink/asdf-tekton-cli)                                 | [![Build Status](https://travis-ci.org/johnhamelink/asdf-tekton-cli.svg?branch=master)](https://travis-ci.org/johnhamelink/asdf-tekton-cli)                                                                                       |
| Teleport Enterprise           | [highb/asdf-teleport-ent](https://github.com/highb/asdf-teleport-ent)                                           | [![Build](https://github.com/highb/asdf-teleport-ent/actions/workflows/build.yml/badge.svg)](https://github.com/highb/asdf-teleport-ent/actions/workflows/build.yml)                                                              |
| Teleport Community            | [MaloPolese/asdf-teleport-community](https://github.com/MaloPolese/asdf-teleport-community)                     | [![Build](https://github.com/MaloPolese/asdf-teleport-community/actions/workflows/build.yml/badge.svg)](https://github.com/MaloPolese/asdf-teleport-community/actions/workflows/build.yml)                                        |
| telepresence                  | [pirackr/asdf-telepresence](https://github.com/pirackr/asdf-telepresence)                                       | [![Build](https://github.com/pirackr/asdf-telepresence/actions/workflows/build.yml/badge.svg)](https://github.com/pirackr/asdf-telepresence/actions/workflows/build.yml)                                                          |
| terradozer                    | [chessmango/asdf-terradozer](https://github.com/chessmango/asdf-terradozer)                                     | [![GitHub Actions Status](https://github.com/chessmango/asdf-terradozer/actions/workflows/build.yml/badge.svg)](https://github.com/chessmango/asdf-terradozer/actions)                                                            |
| Terraform                     | [asdf-community/asdf-hashicorp](https://github.com/asdf-community/asdf-hashicorp)                               | [![Build](https://github.com/asdf-community/asdf-hashicorp/actions/workflows/workflow.yml/badge.svg)](https://github.com/asdf-community/asdf-hashicorp/actions/workflows/workflow.yml)                                            |
| Terraform-docs                | [looztra/asdf-terraform-docs](https://github.com/looztra/asdf-terraform-docs)                                   | [![Build Status](https://travis-ci.org/looztra/asdf-terraform-docs.svg?branch=master)](https://travis-ci.org/looztra/asdf-terraform-docs)                                                                                         |
| terraform-ls                  | [asdf-community/asdf-hashicorp](https://github.com/asdf-community/asdf-hashicorp)                               | [![Build](https://github.com/asdf-community/asdf-hashicorp/actions/workflows/workflow.yml/badge.svg)](https://github.com/asdf-community/asdf-hashicorp/actions/workflows/workflow.yml)                                            |
| terraform-lsp                 | [bartlomiejdanek/asdf-terraform-lsp](https://github.com/bartlomiejdanek/asdf-terraform-lsp)                     | [![Build Status](https://github.com/bartlomiejdanek/asdf-terraform-lsp/workflows/CI/badge.svg?branch=master)](https://github.com/bartlomiejdanek/asdf-terraform-lsp/actions)                                                      |
| Terraform-validator           | [looztra/asdf-terraform-validator](https://github.com/looztra/asdf-terraform-validator)                         | [![Build Status](https://travis-ci.org/looztra/asdf-terraform-validator.svg?branch=master)](https://travis-ci.org/looztra/asdf-terraform-validator)                                                                               |
| Terragrunt                    | [ohmer/asdf-terragrunt](https://github.com/ohmer/asdf-terragrunt)                                               | [![Build Status](https://github.com/ohmer/asdf-terragrunt/actions/workflows/ci.yml/badge.svg?branch=main)](https://github.com/ohmer/asdf-terragrunt/actions/workflows/ci.yml)                                                     |
| Terramate                     | [martinlindner/asdf-terramate](https://github.com/martinlindner/asdf-terramate)                                 | [![Build](https://github.com/martinlindner/asdf-terramate/actions/workflows/build.yml/badge.svg)](https://github.com/martinlindner/asdf-terramate/actions/workflows/build.yml)                                                    |
| tfctl                         | [deas/asdf-tfctl](https://github.com/deas/asdf-tfctl)                                                           | [![Build](https://github.com/deas/asdf-tfctl/actions/workflows/build.yml/badge.svg)](https://github.com/deas/asdf-tfctl/actions/workflows/build.yml)                                                                              |
| tfc-agent                     | [asdf-community/asdf-hashicorp](https://github.com/asdf-community/asdf-hashicorp)                               | [![Build](https://github.com/asdf-community/asdf-hashicorp/actions/workflows/workflow.yml/badge.svg)](https://github.com/asdf-community/asdf-hashicorp/actions/workflows/workflow.yml)                                            |
| tfenv                         | [carlduevel/asdf-tfenv](https://github.com/carlduevel/asdf-tfenv)                                               | [![Build Status](https://github.com/carlduevel/asdf-tfenv/actions/workflows/build.yml/badge.svg?branch=main)](https://github.com/carlduevel/asdf-tfenv/actions/workflows/build.yml)                                               |
| TFLint                        | [skyzyx/asdf-tflint](https://github.com/skyzyx/asdf-tflint)                                                     | [![Build Status](https://travis-ci.org/skyzyx/asdf-tflint.svg?branch=master)](https://travis-ci.org/skyzyx/asdf-tflint)                                                                                                           |
| tfmigrate                     | [dex4er/asdf-tfmigrate](https://github.com/dex4er/asdf-tfmigrate)                                               | [![CI](https://github.com/dex4er/asdf-tfmigrate/actions/workflows/ci.yml/badge.svg)](https://github.com/dex4er/asdf-tfmigrate/actions/workflows/ci.yml)                                                                           |
| TFSec                         | [woneill/asdf-tfsec](https://github.com/woneill/asdf-tfsec)                                                     | [![Build Status](https://github.com/woneill/asdf-tfsec/workflows/master/badge.svg?branch=master)](https://github.com/woneill/asdf-tfsec/actions)                                                                                  |
| tfstate-lookup                | [carnei-ro/asdf-tfstate-lookup](https://github.com/carnei-ro/asdf-tfstate-lookup)                               | [![Build Status](https://github.com/carnei-ro/asdf-tfstate-lookup/actions/workflows/build.yml/badge.svg?branch=main)](https://github.com/carnei-ro/asdf-tfstate-lookup/actions)                                                   |
| tfupdate                      | [yuokada/asdf-tfupdate](https://github.com/yuokada/asdf-tfupdate)                                               | [![Build Status](https://github.com/yuokada/asdf-tfupdate/workflows/Test%20asdf%20plugin/badge.svg?branch=master)](https://github.com/yuokada/asdf-tfupdate/actions)                                                              |
| tf-summarize                  | [adamcrews/asdf-tf-summarize](https://github.com/adamcrews/asdf-tf-summarize)                                   | [![Build](https://github.com/adamcrews/asdf-tf-summarize/actions/workflows/build.yml/badge.svg)](https://github.com/adamcrews/asdf-tf-summarize/actions/workflows/build.yml)                                                      |
| Thrift                        | [alisaifee/asdf-thrift](https://github.com/alisaifee/asdf-thrift)                                               | [![Build Status](https://github.com/alisaifee/asdf-thrift/actions/workflows/main.yml/badge.svg)](https://github.com/alisaifee/asdf-thrift/actions)                                                                                |
| Tilt                          | [eaceaser/tilt](https://github.com/eaceaser/asdf-tilt)                                                          | [![CI workflow](https://github.com/eaceaser/asdf-tilt/workflows/CI/badge.svg)](https://github.com/eaceaser/asdf-tilt/actions)                                                                                                     |
| Titan                         | [gabitchov/asdf-titan](https://github.com/gabitchov/asdf-titan)                                                 | [![Build](https://github.com/Gabitchov/asdf-titan/actions/workflows/build.yml/badge.svg)](https://github.com/Gabitchov/asdf-titan/actions/workflows/build.yml)                                                                    |
| Tmux                          | [aphecetche/asdf-tmux](https://github.com/aphecetche/asdf-tmux)                                                 | [![Build Status](https://travis-ci.org/aphecetche/asdf-tmux.svg?branch=master)](https://travis-ci.org/aphecetche/asdf-tmux)                                                                                                       |
| Tokei                         | [gasuketsu/asdf-tokei](https://github.com/gasuketsu/asdf-tokei)                                                 | [![Build](https://github.com/gasuketsu/asdf-tokei/actions/workflows/build.yml/badge.svg)](https://github.com/gasuketsu/asdf-tokei/actions/workflows/build.yml)                                                                    |
| tomcat                        | [mbutov/asdf-tomcat](https://github.com/mbutov/asdf-tomcat)                                                     | [![GitHub Actions Status](https://github.com/mbutov/asdf-tomcat/actions/workflows/build.yml/badge.svg?branch=main)](https://github.com/mbutov/asdf-tomcat/actions/workflows/build.yml)                                            |
| tonnage                       | [elementalvoid/asdf-tonnage](https://github.com/elementalvoid/asdf-tonnage)                                     | [![GitHub Actions Status](https://github.com/elementalvoid/asdf-tonnage/workflows/Build/badge.svg?branch=main)](https://github.com/elementalvoid/asdf-tonnage/actions)                                                            |
| tool-versions-to-env          | [smartcontractkit/tool-versions-to-env-action](https://github.com/smartcontractkit/tool-versions-to-env-action) | [![GitHub Actions Status](https://github.com/smartcontractkit/tool-versions-to-env-action/workflows/test%20asdf%20plugin/badge.svg?branch=main)](https://github.com/smartcontractkit/tool-versions-to-env-action)                 |
| Trdsql                        | [johnlayton/asdf-trdsql](https://github.com/johnlayton/asdf-trdsql)                                             | [![GitHub Actions Status](https://github.com/johnlayton/asdf-trdsql/workflows/main/badge.svg?branch=master)](https://github.com/johnlayton/asdf-trdsql/actions)                                                                   |
| tridentctl                    | [asdf-community/asdf-tridentctl](https://github.com/asdf-community/asdf-tridentctl)                             | ![CI](https://github.com/asdf-community/asdf-tridentctl/workflows/CI/badge.svg)                                                                                                                                                   |
| Trivy                         | [zufardhiyaulhaq/asdf-trivy](https://github.com/zufardhiyaulhaq/asdf-trivy)                                     | [![Build](https://github.com/zufardhiyaulhaq/asdf-trivy/actions/workflows/build.yml/badge.svg)](https://github.com/zufardhiyaulhaq/asdf-trivy/actions/workflows/build.yml)                                                        |
| tsuru                         | [virtualstaticvoid/asdf-tsuru](https://github.com/virtualstaticvoid/asdf-tsuru)                                 | [![Build Status](https://github.com/virtualstaticvoid/asdf-tsuru/actions/workflows/workflow.yml/badge.svg?branch=main)](https://github.com/virtualstaticvoid/asdf-tsuru/actions/workflows/workflow.yml)                           |
| upt                           | [upt](https://github.com/ORCID/asdf-upt)                                                                        | [![Build](https://github.com/ORCID/asdf-upt/actions/workflows/build.yml/badge.svg)](https://github.com/ORCID/asdf-upt/actions/workflows/build.yml)                                                                                |
| upx                           | [jimmidyson/asdf-upx](https://github.com/jimmidyson/asdf-upx)                                                   | [![Build Status](https://github.com/jimmidyson/asdf-upx/workflows/ci/badge.svg?branch=main)](https://github.com/jimmidyson/asdf-upx/actions)                                                                                      |
| usql                          | [itspngu/asdf-usql](https://github.com/itspngu/asdf-usql)                                                       | [![CI](https://github.com/itspngu/asdf-usql/workflows/CI/badge.svg)](https://github.com/itspngu/asdf-usql/actions/workflows/test.yml)                                                                                             |
| V                             | [jthegedus/asdf-v](https://github.com/jthegedus/asdf-v)                                                         | [![Build Status](https://github.com/jthegedus/asdf-v/workflows/Test/badge.svg)](https://github.com/jthegedus/asdf-v/actions/workflows/test.yml)                                                                                   |
| vals                          | [dex4er/asdf-vals](https://github.com/dex4er/asdf-vals)                                                         | [![CI](https://github.com/dex4er/asdf-vals/actions/workflows/ci.yml/badge.svg)](https://github.com/dex4er/asdf-vals/actions/workflows/ci.yml)                                                                                     |
| Vault                         | [asdf-community/asdf-hashicorp](https://github.com/asdf-community/asdf-hashicorp)                               | [![Build](https://github.com/asdf-community/asdf-hashicorp/actions/workflows/workflow.yml/badge.svg)](https://github.com/asdf-community/asdf-hashicorp/actions/workflows/workflow.yml)                                            |
| Velero                        | [looztra/asdf-velero](https://github.com/looztra/asdf-velero)                                                   | [![Build Status](https://travis-ci.org/looztra/asdf-velero.svg?branch=master)](https://travis-ci.org/looztra/asdf-velero)                                                                                                         |
| vendir                        | [vmware-tanzu/asdf-carvel](https://github.com/vmware-tanzu/asdf-carvel)                                         | [![Build Status](https://github.com/vmware-tanzu/asdf-carvel/workflows/test-all/badge.svg)](https://github.com/vmware-tanzu/asdf-carvel/actions)                                                                                  |
| vcluster                      | [wt0f/asdf-vcluster](https://gitlab.com/wt0f/asdf-vcluster)                                                     | [![Pipeline Status](https://gitlab.com/wt0f/asdf-vcluster/badges/master/pipeline.svg)](https://gitlab.com/wt0f/asdf-vcluster/-/commits/main)                                                                                      |
| vela                          | [pdemagny/asdf-vela](https://github.com/pdemagny/asdf-vela)                                                     | [![Build Status](https://github.com/pdemagny/asdf-vela/actions/workflows/build.yml/badge.svg)](https://github.com/pdemagny/asdf-vela/actions)                                                                                     |
| velad                         | [pdemagny/asdf-velad](https://github.com/pdemagny/asdf-velad)                                                   | [![Build Status](https://github.com/pdemagny/asdf-velad/actions/workflows/build.yml/badge.svg)](https://github.com/pdemagny/asdf-velad/actions)                                                                                   |
| vhs                           | [chessmango/asdf-vhs](https://github.com/chessmango/asdf-vhs)                                                   | [![GitHub Actions Status](https://github.com/chessmango/asdf-vhs/actions/workflows/build.yml/badge.svg)](https://github.com/chessmango/asdf-vhs/actions)                                                                          |
| Viddy                         | [ryodocx/asdf-viddy](https://github.com/ryodocx/asdf-viddy)                                                     | [![GitHub Actions Status](https://github.com/ryodocx/asdf-viddy/workflows/Build/badge.svg)](https://github.com/ryodocx/asdf-viddy/actions)                                                                                        |
| Vim                           | [tsuyoshicho/asdf-vim](https://github.com/tsuyoshicho/asdf-vim)                                                 | [![GitHub Actions Status:Commit](https://github.com/tsuyoshicho/asdf-vim/workflows/Commit%20workflow/badge.svg)](https://github.com/tsuyoshicho/asdf-vim/actions)                                                                 |
| vultr-cli                     | [ikuradon/asdf-vultr-cli](https://github.com/ikuradon/asdf-vultr-cli)                                           | [![GitHub Actions Status:Commit](https://github.com/ikuradon/asdf-vultr-cli/workflows/Build/badge.svg)](https://github.com/ikuradon/asdf-vultr-cli/actions)                                                                       |
| watchexec                     | [nyrst/asdf-watchexec](https://github.com/nyrst/asdf-watchexec)                                                 | [![pipeline status](https://github.com/nyrst/asdf-watchexec/workflows/Build/badge.svg)](https://github.com/nyrst/asdf-watchexec/actions)                                                                                          |
| WASI SDK                      | [coolreader18/asdf-wasi-sdk](https://github.com/coolreader18/asdf-wasi-sdk)                                     | [![Build Status](https://github.com/coolreader18/asdf-wasi-sdk/workflows/Build/badge.svg)](https://github.com/coolreader18/asdf-wasi-sdk/actions)                                                                                 |
| WASM-4                        | [jtakakura/asdf-wasm4](https://github.com/jtakakura/asdf-wasm4)                                                 | [![Build Status](https://github.com/jtakakura/asdf-wasm4/workflows/Build/badge.svg)](https://github.com/jtakakura/asdf-wasm4/actions?query=workflow%3ABuild)                                                                      |
| wasm3                         | [tachyonicbytes/asdf-wasm3](https://github.com/tachyonicbytes/asdf-wasm3)                                       | [![Build Status](https://github.com/tachyonicbytes/asdf-wasm3/workflows/Build/badge.svg)](https://github.com/tachyonicbytes/asdf-wasm3/actions?query=workflow%3ABuild)                                                            |
| wasmer                        | [tachyonicbytes/asdf-wasmer](https://github.com/tachyonicbytes/asdf-wasmer)                                     | [![Build Status](https://github.com/tachyonicbytes/asdf-wasmer/workflows/Build/badge.svg)](https://github.com/tachyonicbytes/asdf-wasmer/actions?query=workflow%3ABuild)                                                          |
| wasmtime                      | [tachyonicbytes/asdf-wasmtime](https://github.com/tachyonicbytes/asdf-wasmtime)                                 | [![Build Status](https://github.com/tachyonicbytes/asdf-wasmtime/workflows/Build/badge.svg)](https://github.com/tachyonicbytes/asdf-wasmtime/actions?query=workflow%3ABuild)                                                      |
| Waypoint                      | [asdf-community/asdf-hashicorp](https://github.com/asdf-community/asdf-hashicorp)                               | [![Build](https://github.com/asdf-community/asdf-hashicorp/actions/workflows/workflow.yml/badge.svg)](https://github.com/asdf-community/asdf-hashicorp/actions/workflows/workflow.yml)                                            |
| weave-gitops                  | [deas/asdf-weave-gitops](https://github.com/deas/asdf-weave-gitops)                                             | [![Build](https://github.com/deas/asdf-weave-gitops/actions/workflows/build.yml/badge.svg)](https://github.com/deas/asdf-weave-gitops/actions/workflows/build.yml)                                                                |
| Websocat                      | [bdellegrazie/asdf-websocat](https://github.com/bdellegrazie/asdf-websocat)                                     | [![GitHub Actions Status](https://github.com/bdellegrazie/asdf-websocat/workflows/Build/badge.svg?branch=master)](https://github.com/bdellegrazie/asdf-websocat/actions)                                                          |
| Wren CLI                      | [jtakakura/asdf-wren-cli](https://github.com/jtakakura/asdf-wren-cli)                                           | [![Build Status](https://github.com/jtakakura/asdf-wren-cli/workflows/Build/badge.svg)](https://github.com/jtakakura/asdf-wren-cli/actions?query=workflow%3ABuild)                                                                |
| Wtfutil                       | [NeoHsu/asdf-wtfutil](https://github.com/NeoHsu/asdf-wtfutil)                                                   | [![Build](https://github.com/NeoHsu/asdf-wtfutil/workflows/Build/badge.svg)](https://github.com/neohsu/asdf-wtfutil/actions?query=workflow%3ABuild)                                                                               |
| XCTestHTMLReport              | [younke/asdf-xchtmlreport](https://github.com/younke/asdf-xchtmlreport)                                         | [![Build Status](https://github.com/younke/asdf-xchtmlreport/workflows/Build/badge.svg?branch=main)](https://github.com/younke/asdf-xchtmlreport/actions)                                                                         |
| XcodeGen                      | [younke/asdf-xcodegen](https://github.com/younke/asdf-xcodegen)                                                 | [![Build Status](https://github.com/younke/asdf-xcodegen/workflows/Build/badge.svg?branch=master)](https://github.com/younke/asdf-xcodegen/actions)                                                                               |
| xh                            | [NeoHsu/asdf-xh](https://github.com/NeoHsu/asdf-xh)                                                             | [![Build](https://github.com/NeoHsu/asdf-xh/workflows/Build/badge.svg)](https://github.com/neohsu/asdf-xh/actions?query=workflow%3ABuild)                                                                                         |
| yadm                          | [particledecay/asdf-yadm](https://github.com/particledecay/asdf-yadm)                                           | [![Test Plugin](https://github.com/particledecay/asdf-yadm/workflows/Plugin%20Test/badge.svg)](https://github.com/particledecay/asdf-yadm/actions)                                                                                |
| Yarn                          | [twuni/asdf-yarn](https://github.com/twuni/asdf-yarn)                                                           | [![Build Status](https://travis-ci.org/twuni/asdf-yarn.svg?branch=master)](https://travis-ci.org/twuni/asdf-yarn)                                                                                                                 |
| yay                           | [aaaaninja/asdf-yay](https://github.com/aaaaninja/asdf-yay)                                                     | [![Build Status](https://github.com/aaaaninja/asdf-yay/actions/workflows/build.yml/badge.svg)](https://github.com/aaaaninja/asdf-yay/actions/workflows/build.yml)                                                                 |
| Yor                           | [ordinaryexperts/asdf-yor](https://github.com/ordinaryexperts/asdf-yor)                                         | [![Build](https://github.com/ordinaryexperts/asdf-yor/actions/workflows/build.yml/badge.svg)](https://github.com/ordinaryexperts/asdf-yor/actions/workflows/build.yml)                                                            |
| yj                            | [ryodocx/asdf-yj](https://github.com/ryodocx/asdf-yj)                                                           | [![GitHub Actions Status](https://github.com/ryodocx/asdf-yj/workflows/Build/badge.svg)](https://github.com/ryodocx/asdf-yj/actions)                                                                                              |
| yq                            | [sudermajr/asdf-yq](https://github.com/sudermanjr/asdf-yq)                                                      | [![Build Status](https://github.com/sudermanjr/asdf-yq/workflows/master/badge.svg?branch=master)](https://github.com/sudermanjr/asdf-yq/actions)                                                                                  |
| ytt                           | [vmware-tanzu/asdf-carvel](https://github.com/vmware-tanzu/asdf-carvel)                                         | [![Build Status](https://github.com/vmware-tanzu/asdf-carvel/workflows/test-all/badge.svg)](https://github.com/vmware-tanzu/asdf-carvel/actions)                                                                                  |
| zellij                        | [chessmango/asdf-zellij](https://github.com/chessmango/asdf-zellij)                                             | [![GitHub Actions Status](https://github.com/chessmango/asdf-zellij/actions/workflows/build.yml/badge.svg)](https://github.com/chessmango/asdf-zellij/actions)                                                                    |
| Zephyr                        | [nsaunders/asdf-zephyr](https://github.com/nsaunders/asdf-zephyr)                                               | [![Build Status](https://github.com/nsaunders/asdf-zephyr/workflows/Build/badge.svg?branch=master)](https://github.com/nsaunders/asdf-zephyr/actions)                                                                             |
| Zig                           | [cheetah/asdf-zig](https://github.com/cheetah/asdf-zig)                                                         | [![Build Status](https://github.com/cheetah/asdf-zig/actions/workflows/build.yml/badge.svg?branch=master)](https://github.com/cheetah/asdf-zig/actions/workflows/build.yml)                                                       |
| zigmod                        | [kachick/asdf-zigmod](https://github.com/kachick/asdf-zigmod)                                                   | [![Build Status](https://github.com/kachick/asdf-zigmod/actions/workflows/build.yml/badge.svg?branch=main)](https://github.com/kachick/asdf-zigmod/actions)                                                                       |
| Zola                          | [salasrod/asdf-zola](https://github.com/salasrod/asdf-zola)                                                     | [![Build Status](https://github.com/salasrod/asdf-zola/workflows/CI/badge.svg?branch=master)](https://github.com/salasrod/asdf-zola/actions)                                                                                      |
| zoxide                        | [nyrst/zoxide](https://github.com/nyrst/asdf-zoxide)                                                            | [![Build Status](https://github.com/nyrst/asdf-zoxide/workflows/Build/badge.svg)](https://github.com/nyrst/asdf-zoxide/actions)                                                                                                   |
| zprint                        | [carlduevel/asdf-zprint](https://github.com/carlduevel/asdf-zprint)                                             | [![Build Status](https://github.com/carlduevel/asdf-zprint/actions/workflows/build.yml/badge.svg?branch=main)](https://github.com/carlduevel/asdf-zprint/actions/workflows/build.yml)                                             |
